
package com.ovopark.training.enhancer.subject.gracefulshutdown;

import lombok.extern.slf4j.Slf4j;

import java.util.List;

@Slf4j
public class ShutdownManager {
    private final List<Shutdown> shutdowns;

    public ShutdownManager(List<Shutdown> shutdowns) {
        this.shutdowns = shutdowns;
    }

    public void pause() throws InterruptedException {
        for (Shutdown shutdown : shutdowns) {
            shutdown.pause();
            log.info("pause: {}", shutdown.getClass().getSimpleName());
        }
    }

    public void shutdown(Integer delay) throws InterruptedException {
        for (Shutdown shutdown : shutdowns) {
            shutdown.shutdown(delay);
            log.info("shutdown: {}", shutdown.getClass().getSimpleName());
        }
    }
}
