/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.gracefulshutdown;

import com.ovopark.training.enhancer.subject.gracefulshutdown.GracefulHealth;
import com.ovopark.training.enhancer.subject.gracefulshutdown.GracefulShutdownEndpoint;
import com.ovopark.training.enhancer.subject.gracefulshutdown.GracefulShutdownProperties;
import com.ovopark.training.enhancer.subject.gracefulshutdown.Shutdown;
import com.ovopark.training.enhancer.subject.gracefulshutdown.ShutdownManager;
import com.ovopark.training.enhancer.subject.gracefulshutdown.shutdown.AutoServiceRegistrationShutdown;
import com.ovopark.training.enhancer.subject.gracefulshutdown.shutdown.KafkaShutdown;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

@Configuration
@ConditionalOnProperty(prefix="endpoints.shutdown.graceful", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GracefulShutdownProperties.class})
public class GracefulShutdownAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GracefulShutdownAutoConfiguration.class);

    @Bean
    public HasFeatures gracefulShutdownFeatures() {
        return HasFeatures.namedFeature((String)"graceful shutdown", GracefulShutdownEndpoint.class);
    }

    @Bean
    public GracefulHealth gracefulHealth() {
        return new GracefulHealth();
    }

    @Bean
    @ConditionalOnMissingBean
    protected GracefulShutdownEndpoint gracefulShutdownEndpoint() {
        return new GracefulShutdownEndpoint();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.cloud.client.serviceregistry.AutoServiceRegistration"})
    public AutoServiceRegistrationShutdown autoServiceRegistrationShutdown() {
        return new AutoServiceRegistrationShutdown();
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.kafka.config.KafkaListenerEndpointRegistry"})
    public KafkaShutdown kafkaShutdown() {
        return new KafkaShutdown();
    }

    @Bean
    public ShutdownManager shutdownManager(List<Shutdown> shutdowns) {
        shutdowns = shutdowns.stream().sorted(Comparator.comparing(Ordered::getOrder)).peek(shutdown -> log.info("\u52a0\u8f7d\u505c\u673a\u5904\u7406\u5668: {}", shutdown.getClass())).collect(Collectors.toList());
        return new ShutdownManager(shutdowns);
    }
}

