package com.ovopark.training.enhancer.subject.gracefulshutdown.shutdown;

import com.ovopark.training.enhancer.subject.gracefulshutdown.OrderedShutdown;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistration;
import org.springframework.core.Ordered;

@Slf4j
public class AutoServiceRegistrationShutdown implements OrderedShutdown {

    @Autowired
    private AutoServiceRegistration autoServiceRegistration;

    public AutoServiceRegistrationShutdown() {
    }

    public void pause() throws InterruptedException {
    }

    public void shutdown(Integer delay) throws InterruptedException {
        ((AbstractAutoServiceRegistration) autoServiceRegistration).stop();
        log.info("Stopping AutoServiceRegistration...");
    }

    public int getOrder() {
        return Ordered.HIGHEST_PRECEDENCE;
    }

}
