/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.training.enhancer.subject.resp;

import com.ovopark.training.enhancer.subject.resp.IResult;
import com.ovopark.training.enhancer.subject.resp.IResultWrapper;
import com.ovopark.training.enhancer.subject.resp.Result;

public class ResultUtils {
    private static IResultWrapper resultWrapper;

    public static <T> Result<T> success(T data) {
        return ResultUtils.createResp("ok", data, true);
    }

    public static <T> Result<T> success() {
        return ResultUtils.createResp("ok", null, true);
    }

    public static <T> Result<T> fail() {
        return ResultUtils.createResp("error", null, false);
    }

    public static <T> Result<T> fail(String resultMsg) {
        return ResultUtils.createResp(resultMsg, null, false);
    }

    public static <T> Result<T> failData(T data) {
        return ResultUtils.createResp("error", data, false);
    }

    public static <T> Result<T> fail(String resultMsg, T data) {
        return ResultUtils.createResp(resultMsg, data, false);
    }

    public static <T> Result<T> createResp(String resultMsg, T data, boolean success) {
        Result<T> result = new Result<T>(resultMsg, data, success);
        if (resultWrapper != null) {
            return resultWrapper.wrap(result);
        }
        return result;
    }

    public static void setResultWrapper(IResultWrapper wrapper) {
        resultWrapper = wrapper;
    }

    public static <T> boolean isSuccessAndNotNullData(IResult<T> result) {
        if (result == null) {
            return false;
        }
        if (result.getData() == null) {
            return false;
        }
        return result.isSuccess();
    }
}

