/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.filegateway.utils;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.filegateway.utils.ErrorCodeEnum;
import com.zhongan.filegateway.utils.FileTypeHeaderEnum;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.signature.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCheckUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCheckUtil.class);
    private static final String[] VALIDATE_FILE_HEADER_INDEX = new String[]{"jpg", "png", "jpeg", "doc", "pdf", "bat", "exe", "jar", "tst", "zip", "rar", "doc", "docx", "xls", "xlsx"};
    private static final String[] VALIDATE_RETURN = new String[]{"txt", "json"};

    public static JSONObject checkFileTypeWhiteList(InputStream is, String fileType) {
        JSONObject result = new JSONObject();
        if (null == is || StringUtils.isEmpty(fileType)) {
            result.put("isSuccess", (Object)false);
            result.put("errorCode", (Object)ErrorCodeEnum.PARAM_VALIDATE_FAILED.getCode());
            result.put("errorMsg", (Object)ErrorCodeEnum.PARAM_VALIDATE_FAILED.getDescription());
            return result;
        }
        try {
            if (FileCheckUtil._validateFileIfMarchSuffix(is, fileType)) {
                result.put("isSuccess", (Object)true);
                result.put("fileType", (Object)fileType);
            } else {
                result.put("isSuccess", (Object)false);
                result.put("errorCode", (Object)ErrorCodeEnum.TYPE_ERROR.getCode());
                result.put("errorMsg", (Object)ErrorCodeEnum.TYPE_ERROR.getDescription());
            }
        }
        catch (ZhongAnOpenException e) {
            result.put("isSuccess", (Object)false);
            result.put("errorCode", (Object)e.getErrCode());
            result.put("errorMsg", (Object)e.getErrMsg());
        }
        return result;
    }

    public static void checkFileTypeBlackList(File file, List<String> suffixes) throws ZhongAnOpenException {
        for (String suffix : suffixes) {
            if (!FileCheckUtil.validateFileIfMarchSuffix(file, suffix)) continue;
            throw new ZhongAnOpenException(ErrorCodeEnum.EXECUTE_LIMIT.getCode(), ErrorCodeEnum.EXECUTE_LIMIT.getDescription());
        }
    }

    public static boolean validateFileIfMarchSuffix(File file, String suffix) throws ZhongAnOpenException {
        boolean bl;
        if (file == null) {
            throw new ZhongAnOpenException(ErrorCodeEnum.PARAM_VALIDATE_FAILED.getCode(), "\u6821\u9a8c\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty(suffix)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.PARAM_VALIDATE_FAILED.getCode(), "\u6821\u9a8c\u6587\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            bl = FileCheckUtil._validateFileIfMarchSuffix(is, suffix);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ZhongAnOpenException(ErrorCodeEnum.FILE_NOT_EXIST.getCode(), ErrorCodeEnum.FILE_NOT_EXIST.getDescription());
            }
            catch (Throwable throwable) {
                FileCheckUtil.close(is);
                throw throwable;
            }
        }
        FileCheckUtil.close(is);
        return bl;
    }

    public static void close(InputStream is) {
        if (null != is) {
            try {
                FileCheckUtil._closeStream(is);
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95edIO\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static boolean _validateFileIfMarchSuffix(InputStream is, String suffix) throws ZhongAnOpenException {
        if (Arrays.asList(VALIDATE_FILE_HEADER_INDEX).contains(suffix)) {
            try {
                return FileCheckUtil._validateByFileHeader(is, suffix);
            }
            catch (IOException e) {
                throw new ZhongAnOpenException(ErrorCodeEnum.SYS_ERROR.getCode(), "\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38");
            }
        }
        if (Arrays.asList(VALIDATE_RETURN).contains(suffix)) {
            return true;
        }
        throw new ZhongAnOpenException(ErrorCodeEnum.FILE_HEADER_VALIDATE_NO_SUPPORT.getCode(), ErrorCodeEnum.FILE_HEADER_VALIDATE_NO_SUPPORT.getDescription());
    }

    private static boolean _validateByFileHeader(InputStream is, String suffix) throws IOException, ZhongAnOpenException {
        String header = FileCheckUtil._getFileHeader(is);
        if (StringUtils.isEmpty(header)) {
            throw new ZhongAnOpenException(ErrorCodeEnum.FILE_HEADER_NULL.getCode(), ErrorCodeEnum.FILE_HEADER_NULL.getDescription());
        }
        FileTypeHeaderEnum headerEnum = FileTypeHeaderEnum.getEnumByType(suffix);
        if (null == headerEnum) {
            throw new ZhongAnOpenException(ErrorCodeEnum.FILE_HEADER_VALIDATE_NO_SUPPORT.getCode(), ErrorCodeEnum.FILE_HEADER_VALIDATE_NO_SUPPORT.getDescription());
        }
        return header.equalsIgnoreCase(headerEnum.getHeader());
    }

    private static String _getFileHeader(InputStream is) throws IOException {
        byte[] b = new byte[3];
        is.read(b, 0, b.length);
        return FileCheckUtil._bytesToHexString(b);
    }

    private static String _bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            String hv = Integer.toHexString(src[i] & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    private static void _closeStream(InputStream is) throws IOException {
        is.close();
        is = null;
    }
}

