/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.common;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.common.dto.CommonResponse;
import com.zhongan.scorpoin.common.dto.DefaultRequest;
import com.zhongan.scorpoin.common.enums.KeysEnum;
import com.zhongan.scorpoin.common.enums.SaltTypeEnum;
import com.zhongan.scorpoin.common.enums.SignTypeEnum;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.common.enums.ZhongAnEnvEnum;
import com.zhongan.scorpoin.common.enums.ZhongAnOpenErrorEnum;
import com.zhongan.scorpoin.processor.AbstractSignProcessor;
import com.zhongan.scorpoin.processor.EncryptAndSignFactory;
import com.zhongan.scorpoin.signature.StringUtils;
import com.zhongan.scorpoin.util.ZhongAnOpenHttpUtils;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZhongAnApiClient {
    private int connectTimeout = 3000;
    private int readTimeout = 80000;
    private String env;
    private String appKey;
    private String privateKey;
    private String url;
    private String zaPublicKey;
    private String charset = "UTF-8";
    private String signType = "RSA";
    private String version = "1.0.0";
    private String format = "json";
    private String timestamp;
    private String token;
    private String productId;
    private String salt;
    private String saltType = SaltTypeEnum.EQU_SALT.getCode();
    private Map<String, String> reqHeaders;
    private Map<String, List<String>> resHeaders;

    public ZhongAnApiClient(String env, String appKey, String privateKey) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
    }

    public ZhongAnApiClient(String env, String appKey, String privateKey, String version) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
    }

    public ZhongAnApiClient(String env, String url, String appKey, String privateKey, String version) {
        this.url = url;
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
    }

    public ZhongAnApiClient(String env, String url, String appKey, String privateKey, String version, String signType) {
        this.url = url;
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.version = version;
        this.signType = signType;
    }

    public ZhongAnApiClient(String env, String url, String appKey, String version, String signType, String token, String productId) {
        this.url = url;
        this.env = env;
        this.appKey = appKey;
        this.version = version;
        this.signType = signType;
        this.token = token;
        this.productId = productId;
    }

    public ZhongAnApiClient(String env, String appKey, String privateKey, String charset, String signType, String version, String format, int connectTimeout, int readTimeout) {
        this.env = env;
        this.appKey = appKey;
        this.privateKey = privateKey;
        this.charset = charset;
        this.signType = signType;
        this.version = version;
        this.format = format;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    private void _init() throws ZhongAnOpenException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        this.timestamp = sdf.format(new Date());
        sdf = null;
        ZhongAnEnvEnum envEnum = ZhongAnEnvEnum.get(this.env);
        if (null == envEnum) {
            if (this.env.startsWith("uat")) {
                envEnum = ZhongAnEnvEnum.get("uat");
            } else {
                throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "env\u5fc5\u987b\u662fdev,iTest,uat,prd\u4e2d\u7684\u4e00\u4e2a");
            }
        }
        if (StringUtils.isEmpty(this.url) || "prd".equals(this.env)) {
            this.url = envEnum.getUrl();
        }
        this.zaPublicKey = envEnum.getPublicKey();
        SignTypeEnum signTypeEnum = SignTypeEnum.getSystemParameterEnum(this.signType);
        if (null == signTypeEnum) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.SIGN_TYPE_ERROR.getCode(), "signType\u5fc5\u987b\u662fRSA,APP,RSARC4\u4e2d\u7684\u4e00\u4e2a");
        }
    }

    public CommonResponse call(DefaultRequest req) throws ZhongAnOpenException {
        Map<String, Object> rt;
        this._init();
        req.init();
        req.checkSysParams();
        req.checkBizParams();
        JSONObject encryptSignJSON = req.buildEncryptSignParamMap();
        encryptSignJSON.put(SystemParameterEnum.APP_KEY.getCode(), (Object)this.appKey);
        encryptSignJSON.put(SystemParameterEnum.TIME_STAMP.getCode(), (Object)this.timestamp);
        encryptSignJSON.put(SystemParameterEnum.FORMAT.getCode(), (Object)this.format);
        encryptSignJSON.put(SystemParameterEnum.SIGN_TYPE.getCode(), (Object)this.signType);
        encryptSignJSON.put(SystemParameterEnum.CHARSET.getCode(), (Object)this.charset);
        encryptSignJSON.put(SystemParameterEnum.VERSION.getCode(), (Object)this.version);
        if (SignTypeEnum.SHA1.getCode().equals(this.signType)) {
            encryptSignJSON.put(SystemParameterEnum.TOKEN.getCode(), (Object)this.token);
            encryptSignJSON.put(SystemParameterEnum.PRODUCT_ID.getCode(), (Object)this.productId);
        }
        if (null == (rt = this.doPost(encryptSignJSON))) {
            return null;
        }
        CommonResponse response = null;
        if (null != rt.get("bizContent")) {
            response = new CommonResponse();
            response.setBizContent((String)rt.get("bizContent"));
        } else {
            response = req.getResponse();
        }
        if (null != rt.get("errorCode")) {
            response.setErrorCode((String)rt.get("errorCode"));
        }
        if (null != rt.get("errorMsg")) {
            response.setErrorMsg((String)rt.get("errorMsg"));
        }
        response.setCharset((String)rt.get("charset"));
        response.setFormat((String)rt.get("format"));
        response.setSignType((String)rt.get("signType"));
        response.setTimestamp((String)rt.get("timestamp"));
        return response;
    }

    protected Map<String, Object> doPost(JSONObject paramJSON) throws ZhongAnOpenException {
        String gatewayResponse;
        Map<String, Object> encryptMap;
        AbstractSignProcessor signTypeEncryptAndSign = EncryptAndSignFactory.getSignType(paramJSON.getString("signType"));
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put(KeysEnum.PK.getCode(), this.zaPublicKey);
            params.put(KeysEnum.PRK.getCode(), this.privateKey);
            params.put(KeysEnum.SALT.getCode(), this.salt);
            params.put(KeysEnum.SALT_TYPE.getCode(), this.saltType);
            encryptMap = signTypeEncryptAndSign.xEncryptAndSignBySignType(paramJSON, params);
        }
        catch (Exception var12) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ENCRYPT_SIGN_FAILED.getCode(), var12.getMessage(), var12);
        }
        params = new HashMap();
        for (Map.Entry<String, Object> en : encryptMap.entrySet()) {
            params.put(en.getKey(), (String)en.getValue());
        }
        try {
            Object[] obj = ZhongAnOpenHttpUtils.doPost(this.url, params, "utf-8", this.connectTimeout, this.readTimeout, this.reqHeaders);
            gatewayResponse = (String)obj[0];
            this.resHeaders = (Map)obj[1];
        }
        catch (IOException e) {
            throw new ZhongAnOpenException(e);
        }
        JSONObject responseJson = null;
        try {
            responseJson = JSONObject.parseObject((String)gatewayResponse);
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ERROR_RESPONSE.getCode(), ZhongAnOpenErrorEnum.ERROR_RESPONSE.getDescription());
        }
        try {
            if (SignTypeEnum.SHA1.getCode().equals(paramJSON.getString("signType"))) {
                responseJson.put("bizContent", (Object)responseJson.getString("bizContent"));
            } else {
                HashMap<String, String> keys = new HashMap<String, String>();
                keys.put(KeysEnum.PK.getCode(), this.zaPublicKey);
                keys.put(KeysEnum.PRK.getCode(), this.privateKey);
                keys.put(KeysEnum.SALT.getCode(), this.salt);
                keys.put(KeysEnum.SALT_TYPE.getCode(), this.saltType);
                if (null != responseJson.get((Object)"bizContent")) {
                    String result = signTypeEncryptAndSign.checkSignAndDecrypt((Map<String, Object>)responseJson, keys);
                    responseJson.put("bizContent", (Object)result);
                }
            }
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(e);
        }
        return responseJson;
    }

    public String getSaltType() {
        return this.saltType;
    }

    public void setSaltType(String saltType) {
        this.saltType = saltType;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Map<String, List<String>> getResHeaders() {
        return this.resHeaders;
    }

    public Map<String, String> getReqHeaders() {
        return this.reqHeaders;
    }

    public void setReqHeaders(Map<String, String> reqHeaders) {
        this.reqHeaders = reqHeaders;
    }
}

