/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.common;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.common.enums.ZhongAnEnvEnum;
import com.zhongan.scorpoin.common.enums.ZhongAnOpenErrorEnum;
import com.zhongan.scorpoin.signature.SignatureUtils;
import com.zhongan.scorpoin.signature.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZhongAnNotifyClient {
    private String privateKey;
    private String zaPublicKey;

    public ZhongAnNotifyClient(String env, String privateKey) throws ZhongAnOpenException {
        ZhongAnEnvEnum envEnum = ZhongAnEnvEnum.get(env);
        if (null == envEnum) {
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.ARGUMENTS_ILLEGAL.getCode(), "env\u5fc5\u987b\u662fdev,iTest,uat,prd\u4e2d\u7684\u4e00\u4e2a");
        }
        this.zaPublicKey = envEnum.getPublicKey();
        this.privateKey = privateKey;
    }

    public String parseNotifyRequest(Map<String, String[]> map) throws ZhongAnOpenException {
        JSONObject params = this.parseParams(map);
        return this.parseNotifyRequest(params);
    }

    public String parseNotifyRequest(JSONObject params) throws ZhongAnOpenException {
        boolean isDecrypt = !StringUtils.isEmpty(params.getString("bizContent"));
        try {
            String responseBizContent = SignatureUtils.checkSignAndDecrypt((Map<String, Object>)params, this.zaPublicKey, this.privateKey, true, isDecrypt);
            return responseBizContent;
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(e);
        }
    }

    public String buildNotifyResponse(String responseClear) throws ZhongAnOpenException {
        String bizcont;
        JSONObject result = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String signType = "RSA";
        try {
            bizcont = SignatureUtils.rsaEncrypt(responseClear, this.zaPublicKey, "UTF-8");
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(e);
        }
        result.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)bizcont);
        result.put(SystemParameterEnum.SIGN_TYPE.getCode(), (Object)signType);
        result.put(SystemParameterEnum.CHARSET.getCode(), (Object)SystemParameterEnum.CHARSET.getDefaultValue());
        result.put(SystemParameterEnum.FORMAT.getCode(), (Object)SystemParameterEnum.FORMAT.getDefaultValue());
        result.put(SystemParameterEnum.TIME_STAMP.getCode(), (Object)sdf.format(new Date()));
        try {
            result.put(SystemParameterEnum.SIGN.getCode(), (Object)SignatureUtils.rsaSign((Map<String, Object>)result, this.privateKey, "UTF-8"));
        }
        catch (Exception e) {
            throw new ZhongAnOpenException(e);
        }
        return result.toJSONString();
    }

    private JSONObject parseParams(Map<String, String[]> map) {
        JSONObject result = new JSONObject();
        Iterator<String> iter = map.keySet().iterator();
        String key = null;
        while (iter.hasNext()) {
            key = iter.next();
            if (map.get(key).length == 0) {
                result.put(key, (Object)"");
                continue;
            }
            result.put(key, (Object)map.get(key)[0]);
        }
        return result;
    }
}

