/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.common.enums;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HttpHeaderEnum {
    TIMESTAMP("TIMESTAMP", "\u65f6\u95f4\u6233"),
    CURRENT_TIME("CURRENT_TIME", "\u5f53\u524d\u65f6\u95f4");

    private String code;
    private String description;

    private HttpHeaderEnum(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String getValue(String code) {
        String val = "";
        if (TIMESTAMP.getCode().equals(code)) {
            val = String.valueOf(System.currentTimeMillis());
        } else if (CURRENT_TIME.getCode().equals(code)) {
            Date date = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            val = sdf.format(date);
        }
        return val;
    }

    public static boolean containCode(String code) {
        for (HttpHeaderEnum an : HttpHeaderEnum.values()) {
            if (null == code || !code.equals(an.getCode())) continue;
            return true;
        }
        return false;
    }

    public static HttpHeaderEnum getSystemParameterEnum(String code) {
        for (HttpHeaderEnum an : HttpHeaderEnum.values()) {
            if (null == code || !code.equals(an.getCode())) continue;
            return an;
        }
        return null;
    }

    public static List<Map<String, String>> getListForMap() {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        for (HttpHeaderEnum an : HttpHeaderEnum.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", an.getCode());
            map.put("description", an.getDescription());
            mapList.add(map);
        }
        return mapList;
    }

    public static List<String> getCodeList() {
        ArrayList<String> codeList = new ArrayList<String>();
        for (HttpHeaderEnum ppe : HttpHeaderEnum.values()) {
            codeList.add(ppe.getCode());
        }
        return codeList;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

