/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.processor;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.ZhongAnOpenException;
import com.zhongan.scorpoin.common.enums.KeysEnum;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.common.enums.ZhongAnOpenErrorEnum;
import com.zhongan.scorpoin.processor.AbstractSignProcessor;
import com.zhongan.scorpoin.signature.RC4Util;
import com.zhongan.scorpoin.signature.SignatureUtils;
import com.zhongan.scorpoin.signature.StringUtils;
import com.zhongan.scorpoin.util.RandomHelper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSARC4SignProcessor
extends AbstractSignProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RSARC4SignProcessor.class);

    @Override
    public String checkSignAndDecrypt(Map<String, Object> params, Map<String, String> keys) throws Exception {
        LOG.info("RSARC4SignProcessor -> checkSignAndDecrypt");
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        String publicKey = keys.get(KeysEnum.PK.getCode());
        String bizContent = (String)params.get(SystemParameterEnum.BIZ_CONTENT.getCode());
        String sign = (String)params.get(SystemParameterEnum.SIGN.getCode());
        params.remove(SystemParameterEnum.SIGN.getCode());
        String content = SignatureUtils.getSignContent(params);
        LOG.debug("\u7b7e\u540d\u5b57\u7b26\u4e32\u662f\uff1a" + content);
        String charset = (String)params.get(SystemParameterEnum.CHARSET.getCode());
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        SignatureUtils.checkRSASign(sign, content, publicKey, charset);
        String keyRC4 = (String)params.get(SystemParameterEnum.KEY_RC4.getCode());
        if (StringUtils.isEmpty(keyRC4)) {
            LOG.warn("RC4\u7b97\u6cd5\u4e2d\uff0ckey\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ZhongAnOpenException(ZhongAnOpenErrorEnum.SIGN_TYPE_ERROR.getCode(), "RC4\u7b97\u6cd5\u4e2d\uff0ckey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String key = SignatureUtils.rsaDecrypt(keyRC4, privateKey, charset);
        return RC4Util.decryRC4(bizContent, key);
    }

    @Override
    public JSONObject encrypt(String content, String publicKey, String charset) throws Exception {
        LOG.info("RSARC4SignProcessor -> encrypt");
        String keyRC4 = RandomHelper.generateRandomStr(16);
        LOG.info("keyRC4 = " + keyRC4);
        JSONObject result = new JSONObject();
        result.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)RC4Util.encryRC4String(content, keyRC4));
        result.put(SystemParameterEnum.KEY_RC4.getCode(), (Object)SignatureUtils.rsaEncrypt(keyRC4, publicKey, charset));
        LOG.debug("encrypt result=" + result.toJSONString());
        return result;
    }

    @Override
    public Map<String, Object> encryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        String charset = paramJSON.getString("charset");
        Map<String, Object> businessParamMap = this.buildBizMap((Map<String, Object>)paramJSON);
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String jsonString = JSONObject.toJSONString(businessParamMap);
        JSONObject jsonObject = this.encrypt(jsonString, zaPublicKey, charset);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)jsonObject.getString("bizContent"));
        newMap.put(SystemParameterEnum.KEY_RC4.getCode(), (Object)jsonObject.getString("key"));
        String rsaSign = this.sign(newMap, keys);
        newMap.put(SystemParameterEnum.SIGN.getCode(), (Object)rsaSign);
        return newMap;
    }

    @Override
    public Map<String, Object> xEncryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        String charset = paramJSON.getString("charset");
        Map businessParamMap = (Map)paramJSON.get((Object)"params");
        JSONObject newMap = this.buildSysMap((Map<String, Object>)paramJSON);
        String jsonString = JSONObject.toJSONString((Object)businessParamMap);
        JSONObject jsonObject = this.encrypt(jsonString, zaPublicKey, charset);
        newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)jsonObject.getString("bizContent"));
        newMap.put(SystemParameterEnum.KEY_RC4.getCode(), (Object)jsonObject.getString("key"));
        String rsaSign = this.sign(newMap, keys);
        newMap.put(SystemParameterEnum.SIGN.getCode(), (Object)rsaSign);
        return newMap;
    }

    @Override
    public String sign(JSONObject jsonObject, Map<String, String> keys) throws Exception {
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        return SignatureUtils.rsaSign((Map<String, Object>)jsonObject, privateKey, "utf-8");
    }
}

