/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.processor;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.enums.KeysEnum;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.processor.AbstractSignProcessor;
import com.zhongan.scorpoin.signature.SignatureUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSASignProcessor
extends AbstractSignProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RSASignProcessor.class);

    @Override
    public String checkSignAndDecrypt(Map<String, Object> params, Map<String, String> keys) throws Exception {
        LOG.info("\u5f00\u59cb\u9a8c\u7b7e\uff1aRSASignProcessor -> checkSignAndDecrypt");
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        String publicKey = keys.get(KeysEnum.PK.getCode());
        return SignatureUtils.checkSignAndDecrypt(params, publicKey, privateKey, true, true);
    }

    @Override
    public JSONObject encrypt(String content, String publicKey, String charset) throws Exception {
        if (null == content) {
            LOG.warn("\u52a0\u5bc6\u5185\u5bb9content\u4e0d\u80fd\u4e3anull");
            throw new Exception("\u52a0\u5bc6\u5185\u5bb9content\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isBlank((String)publicKey)) {
            LOG.warn("publicKey\u4e0d\u80fd\u4e3a\u7a7a");
            throw new Exception("publicKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject result = new JSONObject();
        result.put(SystemParameterEnum.BIZ_CONTENT.getCode(), (Object)SignatureUtils.rsaEncrypt(content, publicKey, charset));
        return result;
    }

    @Override
    public Map<String, Object> encryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        return SignatureUtils.encryptAndSign((Map<String, Object>)paramJSON, zaPublicKey, privateKey, "utf-8", true, true);
    }

    @Override
    public Map<String, Object> xEncryptAndSignBySignType(JSONObject paramJSON, Map<String, String> keys) throws Exception {
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        String zaPublicKey = keys.get(KeysEnum.PK.getCode());
        return SignatureUtils.xEncryptAndSign((Map<String, Object>)paramJSON, zaPublicKey, privateKey, "utf-8", true, true);
    }

    @Override
    public String sign(JSONObject jsonObject, Map<String, String> keys) throws Exception {
        String privateKey = keys.get(KeysEnum.PRK.getCode());
        return SignatureUtils.rsaSign((Map<String, Object>)jsonObject, privateKey, "utf-8");
    }
}

