/*
 * Decompiled with CFR 0.152.
 */
package com.zhongan.scorpoin.signature;

import com.alibaba.fastjson.JSONObject;
import com.zhongan.scorpoin.common.enums.SystemParameterEnum;
import com.zhongan.scorpoin.signature.StreamUtils;
import com.zhongan.scorpoin.signature.StringUtils;
import com.zhongan.scorpoin.signature.codec.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureUtils {
    private static final Logger log = LoggerFactory.getLogger(SignatureUtils.class);

    public static String encryptAndSign(String bizContent, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(charset)) {
            charset = "GBK";
        }
        if (isEncrypt) {
            String encrypted = SignatureUtils.rsaEncrypt(bizContent, publicKey, charset);
            sb.append("bizContent=").append(encrypted);
            if (isSign) {
                String sign = SignatureUtils.rsaSign(encrypted, privateKey, charset);
                sb.append("&sign=").append(sign);
            }
        } else if (isSign) {
            sb.append("bizConent=").append(bizContent);
            String sign = SignatureUtils.rsaSign(bizContent, privateKey, charset);
            sb.append("&sign=").append(sign);
        }
        return sb.toString();
    }

    public static String SHA1(String decript) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(decript.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexString.append(0);
                }
                hexString.append(shaHex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static Map<String, Object> encryptAndSign(Map<String, Object> map, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        Set<String> keySet = map.keySet();
        HashMap<String, Object> businessParamMap = new HashMap<String, Object>();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        List<String> codeList = SystemParameterEnum.getCodeList();
        for (String key : keySet) {
            if (!codeList.contains(key)) {
                businessParamMap.put(key, map.get(key));
                continue;
            }
            newMap.put(key, map.get(key));
        }
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (isEncrypt) {
            String encrypted = SignatureUtils.rsaEncrypt(businessParamMap, publicKey, charset);
            newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), encrypted);
            if (isSign) {
                String sign = SignatureUtils.rsaSign(newMap, privateKey, charset);
                newMap.put(SystemParameterEnum.SIGN.getCode(), sign);
            }
        } else if (isSign) {
            newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), SignatureUtils.getSignContent(businessParamMap));
            String sign = SignatureUtils.rsaSign(newMap, privateKey, charset);
            newMap.put(SystemParameterEnum.SIGN.getCode(), sign);
        }
        return newMap;
    }

    public static Map<String, Object> xEncryptAndSign(Map<String, Object> map, String publicKey, String privateKey, String charset, boolean isEncrypt, boolean isSign) throws Exception {
        String sign;
        Set<String> keySet = map.keySet();
        Map businessParamMap = (Map)map.get("params");
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        List<String> codeList = SystemParameterEnum.getCodeList();
        for (String key : keySet) {
            if (!codeList.contains(key)) continue;
            newMap.put(key, map.get(key));
        }
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (isEncrypt) {
            sign = SignatureUtils.rsaEncrypt(businessParamMap, publicKey, charset);
            newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), sign);
            if (isSign) {
                sign = SignatureUtils.rsaSign(newMap, privateKey, charset);
                newMap.put(SystemParameterEnum.SIGN.getCode(), sign);
            }
        } else if (isSign) {
            newMap.put(SystemParameterEnum.BIZ_CONTENT.getCode(), SignatureUtils.getSignContent(businessParamMap));
            sign = SignatureUtils.rsaSign(newMap, privateKey, charset);
            newMap.put(SystemParameterEnum.SIGN.getCode(), sign);
        }
        return newMap;
    }

    public static String checkSignAndDecrypt(Map<String, Object> params, String publicKey, String privateKey, boolean isCheckSign, boolean isDecrypt) throws Exception {
        String bizContent = (String)params.get(SystemParameterEnum.BIZ_CONTENT.getCode());
        String sign = (String)params.get(SystemParameterEnum.SIGN.getCode());
        params.remove(SystemParameterEnum.SIGN.getCode());
        String content = SignatureUtils.getSignContent(params);
        log.debug("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32\u662f\uff1a" + content + " \u7b7e\u540d\u662f:" + sign);
        String charset = (String)params.get(SystemParameterEnum.CHARSET.getCode());
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (isCheckSign) {
            SignatureUtils.checkRSASign(sign, content, publicKey, charset);
        }
        log.info("\u9a8c\u7b7e\u901a\u8fc7,\u5f00\u59cb\u89e3\u5bc6...");
        if (isDecrypt) {
            return SignatureUtils.rsaDecrypt(bizContent, privateKey, charset);
        }
        return bizContent;
    }

    public static String rsaEncrypt(Map<String, Object> map, String publicKey, String charset) throws Exception {
        String bizContent = SignatureUtils.getSignContent(map);
        return SignatureUtils.rsaEncrypt(bizContent, publicKey, charset);
    }

    public static String rsaEncrypt(String content, String publicKey, String charset) throws Exception {
        PublicKey pubKey = SignatureUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        byte[] data = StringUtils.isEmpty(charset) ? content.getBytes() : content.getBytes(charset);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = Base64.encodeBase64(out.toByteArray());
        out.close();
        return StringUtils.isEmpty(charset) ? new String(encryptedData) : new String(encryptedData, charset);
    }

    public static String rsaDecrypt(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey priKey = SignatureUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            byte[] encryptedData = StringUtils.isEmpty(charset) ? Base64.decodeBase64(content.getBytes()) : Base64.decodeBase64(content.getBytes(charset));
            int inputLen = encryptedData.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            int maxDecryptBlock = 128;
            if (privateKey.length() > 1000) {
                maxDecryptBlock = 256;
            }
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > maxDecryptBlock ? cipher.doFinal(encryptedData, offSet, maxDecryptBlock) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxDecryptBlock;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            log.info("\u89e3\u5bc6\u6210\u529f");
            return StringUtils.isEmpty(charset) ? new String(decryptedData) : new String(decryptedData, charset);
        }
        catch (Exception e) {
            throw new Exception("rsaDecrypt failure:EncodeContent = " + content + ",charset = " + charset, e);
        }
    }

    public static String rsaSign(Map<String, Object> params, String privateKey, String charset) throws Exception {
        String content = SignatureUtils.getSignContent(params);
        log.debug("RSA\u5f85\u7b7e\u540d\u4e32\uff1a" + content);
        return SignatureUtils.rsaSign(content, privateKey, charset);
    }

    public static String rsaSign(String content, String privateKey, String charset) throws Exception {
        try {
            PrivateKey priKey = SignatureUtils.getPrivateKeyFromPKCS8("RSA", new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return new String(Base64.encodeBase64(signed));
        }
        catch (Exception e) {
            throw new Exception("RSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static void checkRSASign(Map<String, Object> paramMap, String publicKey) throws Exception {
        if (null == paramMap || !paramMap.keySet().contains(SystemParameterEnum.SIGN.getCode())) {
            throw new Exception("\u8bf7\u6c42\u7684\u53c2\u6570\u65e0\u6548\uff01");
        }
        String sign = (String)paramMap.get(SystemParameterEnum.SIGN.getCode());
        paramMap.remove(SystemParameterEnum.SIGN.getCode());
        String content = SignatureUtils.getSignContent(paramMap);
        SignatureUtils.checkRSASign(sign, content, publicKey, "UTF-8");
    }

    public static void checkRSASign(String sign, String content, String publicKey, String charset) throws Exception {
        if (!SignatureUtils.rsaCheckContent(content, sign, publicKey, charset)) {
            throw new Exception("rsaCheck failure: sign=" + sign + ", content=" + content + ", charset=" + charset + ",devPublicKey=" + publicKey);
        }
    }

    public static String getSignContent(Map<String, Object> sortedParams) {
        JSONObject js = new JSONObject(sortedParams.size(), true);
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            js.put(key, sortedParams.get(key));
        }
        return js.toJSONString();
    }

    public static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) throws Exception {
        if (ins == null || StringUtils.isEmpty(algorithm)) {
            return null;
        }
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        byte[] encodedKey = StreamUtils.readText(ins).getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey));
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            PublicKey pubKey = SignatureUtils.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance("SHA1WithRSA");
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64.decodeBase64(sign.getBytes()));
        }
        catch (Exception e) {
            throw new Exception("RSAcontent=" + content + ",sign=" + sign + ",charset=" + charset, e);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        StringWriter writer = new StringWriter();
        StreamUtils.io(new InputStreamReader(ins), writer);
        byte[] encodedKey = writer.toString().getBytes();
        encodedKey = Base64.decodeBase64(encodedKey);
        return keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
    }
}

