/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.api.feign.order;

import com.ovopark.zhaocai.common.entity.order.Order;
import com.ovopark.zhaocai.common.entity.order.OrderItem;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value="zhaocai-service-order")
public interface OrderFeignClient {
    @PostMapping(value={"/api/v1/orders"})
    public Order createOrder(@RequestBody Order var1);

    @GetMapping(value={"/api/v1/orders/{id}"})
    public Order getOrderById(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/v1/orders/user/{userId}"})
    public List<Order> getOrdersByUserId(@PathVariable(value="userId") Long var1);

    @PutMapping(value={"/api/v1/orders/{id}/status"})
    public Order updateOrderStatus(@PathVariable(value="id") Long var1, @RequestParam(value="status") Integer var2);

    @PutMapping(value={"/api/v1/orders/{id}/pay"})
    public Order payOrder(@PathVariable(value="id") Long var1);

    @GetMapping(value={"/api/v1/orders/new"})
    public List<Order> getNewOrders();

    @GetMapping(value={"/api/v1/orders/items/{orderId}"})
    public List<OrderItem> getOrderItems(@PathVariable(value="orderId") Long var1);
}

