/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.common.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.ovopark.zhaocai.common.config.TenantContext;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MyBatisPlusConfig {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        TenantLineInnerInterceptor tenantLineInnerInterceptor = new TenantLineInnerInterceptor();
        tenantLineInnerInterceptor.setTenantLineHandler(new TenantLineHandler(this){

            public Expression getTenantId() {
                Long tenantId = TenantContext.getTenantId();
                if (tenantId == null) {
                    tenantId = 1L;
                }
                return new LongValue(tenantId.longValue());
            }

            public String getTenantIdColumn() {
                return "tenant_id";
            }

            public boolean ignoreTable(String tableName) {
                return "t_user".equals(tableName);
            }
        });
        interceptor.addInnerInterceptor((InnerInterceptor)tenantLineInnerInterceptor);
        return interceptor;
    }
}

