/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.common.config;

import com.ovopark.zhaocai.common.config.TenantContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class TenantInterceptor
implements HandlerInterceptor {
    private static final String TENANT_ID_HEADER = "X-Tenant-Id";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String tenantIdStr = request.getHeader(TENANT_ID_HEADER);
        if (tenantIdStr != null && !tenantIdStr.isEmpty()) {
            try {
                Long tenantId = Long.parseLong(tenantIdStr);
                TenantContext.setTenantId(tenantId);
            }
            catch (NumberFormatException e) {
                response.setStatus(400);
                return false;
            }
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        TenantContext.clear();
    }
}

