/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.order.controller;

import com.ovopark.zhaocai.common.entity.order.Order;
import com.ovopark.zhaocai.common.entity.order.OrderItem;
import com.ovopark.zhaocai.service.order.service.OrderService;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/orders"})
public class OrderController {
    private final OrderService orderService;

    @PostMapping
    public Order createOrder(@RequestBody Order order) {
        return this.orderService.createOrder(order);
    }

    @GetMapping(value={"/{id}"})
    public Order getOrderById(@PathVariable Long id) {
        return this.orderService.getOrderById(id);
    }

    @GetMapping(value={"/user/{userId}"})
    public List<Order> getOrdersByUserId(@PathVariable Long userId) {
        return this.orderService.getOrdersByUserId(userId);
    }

    @PutMapping(value={"/{id}/status"})
    public Order updateOrderStatus(@PathVariable Long id, @RequestParam Integer status) {
        return this.orderService.updateOrderStatus(id, status);
    }

    @PutMapping(value={"/{id}/pay"})
    public Order payOrder(@PathVariable Long id) {
        return this.orderService.payOrder(id);
    }

    @GetMapping(value={"/new"})
    public List<Order> getNewOrders() {
        return this.orderService.getNewOrders();
    }

    @GetMapping(value={"/items/{orderId}"})
    public List<OrderItem> getOrderItems(@PathVariable Long orderId) {
        return this.orderService.getOrderItems(orderId);
    }

    @PutMapping(value={"/{id}/cancel"})
    public void cancelOrder(@PathVariable Long id) {
        this.orderService.cancelOrder(id);
    }

    public OrderController(OrderService orderService) {
        this.orderService = orderService;
    }
}

