/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.order.service.impl;

import com.ovopark.zhaocai.common.entity.order.Order;
import com.ovopark.zhaocai.common.entity.order.OrderItem;
import com.ovopark.zhaocai.common.enums.OrderStatusEnum;
import com.ovopark.zhaocai.service.order.repository.OrderItemRepository;
import com.ovopark.zhaocai.service.order.repository.OrderRepository;
import com.ovopark.zhaocai.service.order.service.OrderService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderServiceImpl
implements OrderService {
    private final OrderRepository orderRepository;
    private final OrderItemRepository orderItemRepository;

    @Override
    @Transactional
    public Order createOrder(Order order) {
        String orderNo = this.generateOrderNo();
        order.setOrderNo(orderNo);
        order.setStatus(OrderStatusEnum.WAITING_PAY.getCode());
        this.orderRepository.insert(order);
        if (order.getOrderItems() != null && !order.getOrderItems().isEmpty()) {
            for (OrderItem item : order.getOrderItems()) {
                item.setOrderId(order.getId());
                this.orderItemRepository.insert(item);
            }
        }
        return order;
    }

    @Override
    public Order getOrderById(Long id) {
        Order order = (Order)this.orderRepository.selectById(id);
        if (order != null) {
            order.setOrderItems(this.orderItemRepository.findByOrderId(id));
        }
        return order;
    }

    @Override
    public Order getOrderByOrderNo(String orderNo) {
        Order order = this.orderRepository.findByOrderNo(orderNo);
        if (order != null) {
            order.setOrderItems(this.orderItemRepository.findByOrderId(order.getId()));
        }
        return order;
    }

    @Override
    public List<Order> getOrdersByUserId(Long userId) {
        List<Order> orders = this.orderRepository.findByUserId(userId);
        orders.forEach(order -> order.setOrderItems(this.orderItemRepository.findByOrderId(order.getId())));
        return orders;
    }

    @Override
    @Transactional
    public Order updateOrderStatus(Long id, Integer status) {
        Order order = (Order)this.orderRepository.selectById(id);
        if (order == null) {
            throw new RuntimeException("Order not found");
        }
        order.setStatus(status);
        if (status.equals(OrderStatusEnum.WAITING_CONFIRM.getCode())) {
            order.setConfirmTime(LocalDateTime.now());
        } else if (status.equals(OrderStatusEnum.COMPLETED.getCode())) {
            order.setCompleteTime(LocalDateTime.now());
        } else if (status.equals(OrderStatusEnum.CANCELLED.getCode())) {
            order.setCancelTime(LocalDateTime.now());
        }
        this.orderRepository.updateById(order);
        return order;
    }

    @Override
    @Transactional
    public Order payOrder(Long id) {
        Order order = (Order)this.orderRepository.selectById(id);
        if (order == null) {
            throw new RuntimeException("Order not found");
        }
        order.setStatus(OrderStatusEnum.WAITING_CONFIRM.getCode());
        order.setPaymentTime(LocalDateTime.now());
        this.orderRepository.updateById(order);
        return order;
    }

    @Override
    public List<Order> getNewOrders() {
        List<Order> orders = this.orderRepository.findByStatusOrderByCreateTimeDesc(OrderStatusEnum.WAITING_CONFIRM.getCode());
        orders.forEach(order -> order.setOrderItems(this.orderItemRepository.findByOrderId(order.getId())));
        return orders;
    }

    @Override
    public List<OrderItem> getOrderItems(Long orderId) {
        return this.orderItemRepository.findByOrderId(orderId);
    }

    @Override
    @Transactional
    public void cancelOrder(Long id) {
        Order order = (Order)this.orderRepository.selectById(id);
        if (order == null) {
            throw new RuntimeException("Order not found");
        }
        order.setStatus(OrderStatusEnum.CANCELLED.getCode());
        order.setCancelTime(LocalDateTime.now());
        this.orderRepository.updateById(order);
    }

    private String generateOrderNo() {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String random = UUID.randomUUID().toString().substring(0, 6).toUpperCase();
        return timestamp + random;
    }

    public OrderServiceImpl(OrderRepository orderRepository, OrderItemRepository orderItemRepository) {
        this.orderRepository = orderRepository;
        this.orderItemRepository = orderItemRepository;
    }
}

