/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.product.controller;

import com.ovopark.zhaocai.common.entity.product.Category;
import com.ovopark.zhaocai.common.entity.product.Product;
import com.ovopark.zhaocai.service.product.service.ProductService;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class ProductController {
    private final ProductService productService;

    @GetMapping(value={"/products"})
    public List<Product> getProductList() {
        return this.productService.getProductList();
    }

    @GetMapping(value={"/products/{id}"})
    public Product getProductById(@PathVariable Long id) {
        return this.productService.getProductById(id);
    }

    @GetMapping(value={"/categories"})
    public List<Category> getCategoryList() {
        return this.productService.getCategoryList();
    }

    @PostMapping(value={"/products"})
    public Product createProduct(@RequestBody Product product) {
        return this.productService.createProduct(product);
    }

    @PutMapping(value={"/products/{id}"})
    public Product updateProduct(@PathVariable Long id, @RequestBody Product product) {
        return this.productService.updateProduct(id, product);
    }

    @DeleteMapping(value={"/products/{id}"})
    public void deleteProduct(@PathVariable Long id) {
        this.productService.deleteProduct(id);
    }

    public ProductController(ProductService productService) {
        this.productService = productService;
    }
}

