/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.product.service.impl;

import com.ovopark.zhaocai.common.entity.product.Category;
import com.ovopark.zhaocai.common.entity.product.Product;
import com.ovopark.zhaocai.service.product.repository.CategoryRepository;
import com.ovopark.zhaocai.service.product.repository.ProductRepository;
import com.ovopark.zhaocai.service.product.service.ProductService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProductServiceImpl
implements ProductService {
    private final ProductRepository productRepository;
    private final CategoryRepository categoryRepository;

    @Override
    public List<Product> getProductList() {
        return this.productRepository.selectList(null);
    }

    @Override
    public Product getProductById(Long id) {
        return (Product)this.productRepository.selectById(id);
    }

    @Override
    @Transactional
    public Product createProduct(Product product) {
        this.productRepository.insert(product);
        return product;
    }

    @Override
    @Transactional
    public Product updateProduct(Long id, Product product) {
        Product existingProduct = (Product)this.productRepository.selectById(id);
        if (existingProduct == null) {
            throw new RuntimeException("Product not found");
        }
        if (product.getName() != null) {
            existingProduct.setName(product.getName());
        }
        if (product.getDescription() != null) {
            existingProduct.setDescription(product.getDescription());
        }
        if (product.getPrice() != null) {
            existingProduct.setPrice(product.getPrice());
        }
        if (product.getStock() != null) {
            existingProduct.setStock(product.getStock());
        }
        if (product.getCategoryId() != null) {
            existingProduct.setCategoryId(product.getCategoryId());
        }
        if (product.getImageUrl() != null) {
            existingProduct.setImageUrl(product.getImageUrl());
        }
        if (product.getIsEnable() != null) {
            existingProduct.setIsEnable(product.getIsEnable());
        }
        this.productRepository.updateById(existingProduct);
        return existingProduct;
    }

    @Override
    @Transactional
    public void deleteProduct(Long id) {
        this.productRepository.deleteById(id);
    }

    @Override
    public List<Category> getCategoryList() {
        return this.categoryRepository.selectList(null);
    }

    public ProductServiceImpl(ProductRepository productRepository, CategoryRepository categoryRepository) {
        this.productRepository = productRepository;
        this.categoryRepository = categoryRepository;
    }
}

