/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.user.controller;

import com.ovopark.zhaocai.common.entity.user.User;
import com.ovopark.zhaocai.service.user.service.UserService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/users"})
public class UserController {
    private final UserService userService;

    @GetMapping(value={"/{id}"})
    public User getUserById(@PathVariable Long id) {
        return this.userService.getUserById(id);
    }

    @GetMapping(value={"/openid/{openid}"})
    public User getUserByOpenid(@PathVariable String openid) {
        return this.userService.getUserByOpenid(openid);
    }

    @PostMapping
    public User createUser(@RequestBody User user) {
        return this.userService.createUser(user);
    }

    @PutMapping(value={"/{id}"})
    public User updateUser(@PathVariable Long id, @RequestBody User user) {
        return this.userService.updateUser(id, user);
    }

    @GetMapping(value={"/{id}/profile"})
    public User getUserProfile(@PathVariable Long id) {
        return this.userService.getUserProfile(id);
    }

    public UserController(UserService userService) {
        this.userService = userService;
    }
}

