/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.zhaocai.service.user.service.impl;

import com.ovopark.zhaocai.common.entity.user.User;
import com.ovopark.zhaocai.service.user.repository.UserRepository;
import com.ovopark.zhaocai.service.user.service.UserService;
import java.time.LocalDateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    private final UserRepository userRepository;

    @Override
    public User getUserById(Long id) {
        return (User)this.userRepository.selectById(id);
    }

    @Override
    public User getUserByOpenid(String openid) {
        return this.userRepository.findByOpenid(openid);
    }

    @Override
    @Transactional
    public User createUser(User user) {
        LocalDateTime now = LocalDateTime.now();
        user.setCreateTime(now);
        user.setUpdateTime(now);
        this.userRepository.insert(user);
        return user;
    }

    @Override
    @Transactional
    public User updateUser(Long id, User user) {
        User existingUser = (User)this.userRepository.selectById(id);
        if (existingUser == null) {
            throw new RuntimeException("User not found");
        }
        if (user.getNickname() != null) {
            existingUser.setNickname(user.getNickname());
        }
        if (user.getAvatarUrl() != null) {
            existingUser.setAvatarUrl(user.getAvatarUrl());
        }
        if (user.getPhone() != null) {
            existingUser.setPhone(user.getPhone());
        }
        if (user.getAddress() != null) {
            existingUser.setAddress(user.getAddress());
        }
        existingUser.setUpdateTime(LocalDateTime.now());
        this.userRepository.updateById(existingUser);
        return existingUser;
    }

    @Override
    public User getUserProfile(Long id) {
        User user = (User)this.userRepository.selectById(id);
        if (user == null) {
            throw new RuntimeException("User not found");
        }
        return user;
    }

    public UserServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

