/*
 * 聚合支付
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.aggpay.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class SignRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<SignRequest> {
    private final String serviceName = "Aggpay";

    private final String resourcePath = "/rest/v1.0/aggpay/sign";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<SignRequest> marshall(SignRequest request) {
        Request<SignRequest> internalRequest = new DefaultRequest<SignRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getPayWay() != null) {
            internalRequest.addParameter("payWay", PrimitiveMarshallerUtils.marshalling(request.getPayWay(), "String"));
        }
        if (request.getChannel() != null) {
            internalRequest.addParameter("channel", PrimitiveMarshallerUtils.marshalling(request.getChannel(), "String"));
        }
        if (request.getSignSource() != null) {
            internalRequest.addParameter("signSource", PrimitiveMarshallerUtils.marshalling(request.getSignSource(), "String"));
        }
        if (request.getAppId() != null) {
            internalRequest.addParameter("appId", PrimitiveMarshallerUtils.marshalling(request.getAppId(), "String"));
        }
        if (request.getPlainId() != null) {
            internalRequest.addParameter("plainId", PrimitiveMarshallerUtils.marshalling(request.getPlainId(), "String"));
        }
        if (request.getAgreementId() != null) {
            internalRequest.addParameter("agreementId", PrimitiveMarshallerUtils.marshalling(request.getAgreementId(), "String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling(request.getNotifyUrl(), "String"));
        }
        if (request.getContractDisplayAccount() != null) {
            internalRequest.addParameter("contractDisplayAccount", PrimitiveMarshallerUtils.marshalling(request.getContractDisplayAccount(), "String"));
        }
        if (request.getReturnInfo() != null) {
            internalRequest.addParameter("returnInfo", PrimitiveMarshallerUtils.marshalling(request.getReturnInfo(), "String"));
        }
        if (request.getExpireTime() != null) {
            internalRequest.addParameter("expireTime", PrimitiveMarshallerUtils.marshalling(request.getExpireTime(), "DateTime"));
        }
        if (request.getInvokeScene() != null) {
            internalRequest.addParameter("invokeScene", PrimitiveMarshallerUtils.marshalling(request.getInvokeScene(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static SignRequestMarshaller INSTANCE = new SignRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static SignRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
