/*
 * 认证
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.auth.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class FaceAuthKycRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<FaceAuthKycRequest> {
    private final String serviceName = "Auth";

    private final String resourcePath = "/rest/v1.0/auth/face-auth-kyc";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<FaceAuthKycRequest> marshall(FaceAuthKycRequest request) {
        Request<FaceAuthKycRequest> internalRequest = new DefaultRequest<FaceAuthKycRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getName() != null) {
            internalRequest.addParameter("name", PrimitiveMarshallerUtils.marshalling(request.getName(), "String"));
        }
        if (request.getCardNo() != null) {
            internalRequest.addParameter("cardNo", PrimitiveMarshallerUtils.marshalling(request.getCardNo(), "String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling(request.getCardType(), "String"));
        }
        if (request.getReturnUrl() != null) {
            internalRequest.addParameter("returnUrl", PrimitiveMarshallerUtils.marshalling(request.getReturnUrl(), "String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling(request.getNotifyUrl(), "String"));
        }
        if (request.getExtraData() != null) {
            internalRequest.addParameter("extraData", PrimitiveMarshallerUtils.marshalling(request.getExtraData(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static FaceAuthKycRequestMarshaller INSTANCE = new FaceAuthKycRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static FaceAuthKycRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
