/*
 * 认证
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.auth.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class MultipleAuthRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<MultipleAuthRequest> {
    private final String serviceName = "Auth";

    private final String resourcePath = "/rest/v1.0/auth/multiple-auth";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<MultipleAuthRequest> marshall(MultipleAuthRequest request) {
        Request<MultipleAuthRequest> internalRequest = new DefaultRequest<MultipleAuthRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getAuthType() != null) {
            internalRequest.addParameter("authType", PrimitiveMarshallerUtils.marshalling(request.getAuthType(), "String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getIdCardNo() != null) {
            internalRequest.addParameter("idCardNo", PrimitiveMarshallerUtils.marshalling(request.getIdCardNo(), "String"));
        }
        if (request.getUsername() != null) {
            internalRequest.addParameter("username", PrimitiveMarshallerUtils.marshalling(request.getUsername(), "String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling(request.getBankCardNo(), "String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling(request.getRemark(), "String"));
        }
        if (request.getMobile() != null) {
            internalRequest.addParameter("mobile", PrimitiveMarshallerUtils.marshalling(request.getMobile(), "String"));
        }
        if (request.getIdCardType() != null) {
            internalRequest.addParameter("idCardType", PrimitiveMarshallerUtils.marshalling(request.getIdCardType(), "String"));
        }
        if (request.getClientSource() != null) {
            internalRequest.addParameter("clientSource", PrimitiveMarshallerUtils.marshalling(request.getClientSource(), "String"));
        }
        if (request.getExtMap() != null) {
            internalRequest.addParameter("extMap", PrimitiveMarshallerUtils.marshalling(request.getExtMap(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static MultipleAuthRequestMarshaller INSTANCE = new MultipleAuthRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static MultipleAuthRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
