/*
 * 认证
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.auth.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Set;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class PERSONALINFORMATIONAUTHRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<PERSONALINFORMATIONAUTHRequest> {
    private final String serviceName = "Auth";

    private final String resourcePath = "/rest/v1.0/auth/person/auth";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    private final Set<String> encryptParams = Sets.newHashSet("idCardNo","name","mobile","bankCardNo");

    @Override
    public Request<PERSONALINFORMATIONAUTHRequest> marshall(PERSONALINFORMATIONAUTHRequest request) {
        wrapEncryptParams(request);
        Request<PERSONALINFORMATIONAUTHRequest> internalRequest = new DefaultRequest<PERSONALINFORMATIONAUTHRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getIdCardType() != null) {
            internalRequest.addParameter("idCardType", PrimitiveMarshallerUtils.marshalling(request.getIdCardType().getValue(), "String"));
        }
        if (request.getIdCardNo() != null) {
            internalRequest.addParameter("idCardNo", PrimitiveMarshallerUtils.marshalling(request.getIdCardNo(), "String"));
        }
        if (request.getName() != null) {
            internalRequest.addParameter("name", PrimitiveMarshallerUtils.marshalling(request.getName(), "String"));
        }
        if (request.getMobile() != null) {
            internalRequest.addParameter("mobile", PrimitiveMarshallerUtils.marshalling(request.getMobile(), "String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling(request.getBankCardNo(), "String"));
        }
        if (request.getAccountLevel() != null) {
            internalRequest.addParameter("accountLevel", PrimitiveMarshallerUtils.marshalling(request.getAccountLevel().getValue(), "String"));
        }
        if (request.getAuthType() != null) {
            internalRequest.addParameter("authType", PrimitiveMarshallerUtils.marshalling(request.getAuthType().getValue(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }

    private void wrapEncryptParams(PERSONALINFORMATIONAUTHRequest request) {
        // 以商户设置为准
        if (BooleanUtils.isFalse(request.getRequestConfig().getNeedEncrypt())) {
            return;
        }
        if (BooleanUtils.isTrue(request.getRequestConfig().getTotalEncrypt())) {
            request.getRequestConfig().addEncryptParams(YopConstants.TOTAL_ENCRYPT_PARAMS);
            return;
        }
        // form请求，部分加密
        request.getRequestConfig().addEncryptParams(encryptParams);
    }

    private static class CacheInstanceHolder {
        public static PERSONALINFORMATIONAUTHRequestMarshaller INSTANCE = new PERSONALINFORMATIONAUTHRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static PERSONALINFORMATIONAUTHRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
