/*
 * Copyright: Copyright (c)2014
 * Company: 易宝支付(YeePay)
 */
package com.yeepay.yop.sdk.service.base.request;

import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

/**
 * title: marshaller基类<br>
 * description: 描述<br>
 * Copyright: Copyright (c)2014<br>
 * Company: 易宝支付(YeePay)<br>
 *
 * @author wdc
 * @version 1.0.0
 * @since 2024/8/20
 */
public class BaseRequestMarshaller {

    public void marshall(Request<?> internalRequest, Map<String, Object> extParamMap) {
        if (null == extParamMap || extParamMap.size() == 0) {
            return;
        }
        final YopContentType contentType = internalRequest.getContentType();
        extParamMap.forEach((k,v) -> {
            if (v instanceof String) {
                internalRequest.addParameter(k, (String) v);
            } else if (v instanceof Collection) {
                Collection<?> vTmp = (Collection<?>)v;
                for (Object o : vTmp) {
                    internalRequest.addParameter(k, String.valueOf(o));
                }
            } else if (v.getClass().isArray()) {
                Object[] objArray = (Object[]) v;
                for (Object o : objArray) {
                    internalRequest.addParameter(k, String.valueOf(o));
                }
            } else if (v instanceof InputStream) {
                if (!YopContentType.MULTIPART_FORM.equals(contentType)) {
                    throw new YopClientException("ReqParam Illegal, InputStream NotSupport, contentType:" + contentType);
                }
                internalRequest.addMultiPartFile(k, restartStream((InputStream) v));
            } else if (v instanceof File) {
                if (!YopContentType.MULTIPART_FORM.equals(contentType)) {
                    throw new YopClientException("ReqParam Illegal, File NotSupport, contentType:" + contentType);
                }
                internalRequest.addMultiPartFile(k, (File) v);
            } else {
                internalRequest.addParameter(k, String.valueOf(v));
            }
        });
    }

    private InputStream restartStream(InputStream inputStream) {
        try {
            if (inputStream instanceof RestartableInputStream) {
                return inputStream;
            }
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            final byte[] buffer = new byte[1024];
            int len;
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            baos.flush();
            return RestartableInputStream.wrap(baos.toByteArray());
        } catch (IOException e) {
            throw new YopClientException("ReqParam Illegal, InputStreamParam Cant Restart, ex:", e);
        }
    }

    public String trimIfNecessary(String originStr) {
        return null != originStr ? originStr.trim() : originStr;
    }
}