/*
 * 商家收银台
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.cashier.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class UnifiedOrderRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<UnifiedOrderRequest> {
    private final String serviceName = "Cashier";

    private final String resourcePath = "/rest/v1.0/cashier/unified/order";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<UnifiedOrderRequest> marshall(UnifiedOrderRequest request) {
        Request<UnifiedOrderRequest> internalRequest = new DefaultRequest<UnifiedOrderRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling(request.getOrderId(), "String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling(request.getOrderAmount(), "BigDecimal"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling(request.getGoodsName(), "String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling(request.getFundProcessType(), "String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling(request.getNotifyUrl(), "String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling(request.getMemo(), "String"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling(request.getExpiredTime(), "String"));
        }
        if (request.getReturnUrl() != null) {
            internalRequest.addParameter("returnUrl", PrimitiveMarshallerUtils.marshalling(request.getReturnUrl(), "String"));
        }
        if (request.getCsNotifyUrl() != null) {
            internalRequest.addParameter("csNotifyUrl", PrimitiveMarshallerUtils.marshalling(request.getCsNotifyUrl(), "String"));
        }
        if (request.getBusinessInfo() != null) {
            internalRequest.addParameter("businessInfo", PrimitiveMarshallerUtils.marshalling(request.getBusinessInfo(), "String"));
        }
        if (request.getPayerInfo() != null) {
            internalRequest.addParameter("payerInfo", PrimitiveMarshallerUtils.marshalling(request.getPayerInfo(), "String"));
        }
        if (request.getLimitPayType() != null) {
            internalRequest.addParameter("limitPayType", PrimitiveMarshallerUtils.marshalling(request.getLimitPayType(), "String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling(request.getCardType(), "String"));
        }
        if (request.getAggParam() != null) {
            internalRequest.addParameter("aggParam", PrimitiveMarshallerUtils.marshalling(request.getAggParam(), "String"));
        }
        if (request.getNoCardParam() != null) {
            internalRequest.addParameter("noCardParam", PrimitiveMarshallerUtils.marshalling(request.getNoCardParam(), "String"));
        }
        if (request.getProductInfo() != null) {
            internalRequest.addParameter("productInfo", PrimitiveMarshallerUtils.marshalling(request.getProductInfo(), "String"));
        }
        if (request.getDivideDetail() != null) {
            internalRequest.addParameter("divideDetail", PrimitiveMarshallerUtils.marshalling(request.getDivideDetail(), "String"));
        }
        if (request.getDivideNotifyUrl() != null) {
            internalRequest.addParameter("divideNotifyUrl", PrimitiveMarshallerUtils.marshalling(request.getDivideNotifyUrl(), "String"));
        }
        if (request.getOtherTypeParam() != null) {
            internalRequest.addParameter("otherTypeParam", PrimitiveMarshallerUtils.marshalling(request.getOtherTypeParam(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static UnifiedOrderRequestMarshaller INSTANCE = new UnifiedOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static UnifiedOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
