/*
 * 无卡交易系统
 * <p>中台的无卡交易系统(Card Not Present)，包含调用统一订单OPR下单及无卡支付服务NCPAY支付的流程</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.cnppay.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class OverseasPayRequestRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<OverseasPayRequestRequest> {
    private final String serviceName = "Cnppay";

    private final String resourcePath = "/rest/v1.0/cnppay/overseas/pay/request";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<OverseasPayRequestRequest> marshall(OverseasPayRequestRequest request) {
        Request<OverseasPayRequestRequest> internalRequest = new DefaultRequest<OverseasPayRequestRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling(request.getOrderId(), "String"));
        }
        if (request.getRequestId() != null) {
            internalRequest.addParameter("requestId", PrimitiveMarshallerUtils.marshalling(request.getRequestId(), "String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling(request.getBankCardNo(), "String"));
        }
        if (request.getBankId() != null) {
            internalRequest.addParameter("bankId", PrimitiveMarshallerUtils.marshalling(request.getBankId(), "String"));
        }
        if (request.getCardFirstName() != null) {
            internalRequest.addParameter("cardFirstName", PrimitiveMarshallerUtils.marshalling(request.getCardFirstName(), "String"));
        }
        if (request.getCardLastName() != null) {
            internalRequest.addParameter("cardLastName", PrimitiveMarshallerUtils.marshalling(request.getCardLastName(), "String"));
        }
        if (request.getMobilePhoneNo() != null) {
            internalRequest.addParameter("mobilePhoneNo", PrimitiveMarshallerUtils.marshalling(request.getMobilePhoneNo(), "String"));
        }
        if (request.getValidDate() != null) {
            internalRequest.addParameter("validDate", PrimitiveMarshallerUtils.marshalling(request.getValidDate(), "String"));
        }
        if (request.getBillCountryCode() != null) {
            internalRequest.addParameter("billCountryCode", PrimitiveMarshallerUtils.marshalling(request.getBillCountryCode(), "String"));
        }
        if (request.getBillProvinceCode() != null) {
            internalRequest.addParameter("billProvinceCode", PrimitiveMarshallerUtils.marshalling(request.getBillProvinceCode(), "String"));
        }
        if (request.getBillCity() != null) {
            internalRequest.addParameter("billCity", PrimitiveMarshallerUtils.marshalling(request.getBillCity(), "String"));
        }
        if (request.getBillAddress() != null) {
            internalRequest.addParameter("billAddress", PrimitiveMarshallerUtils.marshalling(request.getBillAddress(), "String"));
        }
        if (request.getBillPostalCode() != null) {
            internalRequest.addParameter("billPostalCode", PrimitiveMarshallerUtils.marshalling(request.getBillPostalCode(), "String"));
        }
        if (request.getBillEmail() != null) {
            internalRequest.addParameter("billEmail", PrimitiveMarshallerUtils.marshalling(request.getBillEmail(), "String"));
        }
        if (request.getFrontendCallbackUrl() != null) {
            internalRequest.addParameter("frontendCallbackUrl", PrimitiveMarshallerUtils.marshalling(request.getFrontendCallbackUrl(), "String"));
        }
        if (request.getDeviceInfo() != null) {
            internalRequest.addParameter("deviceInfo", PrimitiveMarshallerUtils.marshalling(request.getDeviceInfo(), "String"));
        }
        if (request.getCvv() != null) {
            internalRequest.addParameter("cvv", PrimitiveMarshallerUtils.marshalling(request.getCvv(), "String"));
        }
        if (request.getPayPlatform() != null) {
            internalRequest.addParameter("payPlatform", PrimitiveMarshallerUtils.marshalling(request.getPayPlatform(), "String"));
        }
        if (request.getWorkPhone() != null) {
            internalRequest.addParameter("workPhone", PrimitiveMarshallerUtils.marshalling(request.getWorkPhone(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static OverseasPayRequestRequestMarshaller INSTANCE = new OverseasPayRequestRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static OverseasPayRequestRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
