/*
 * 保险
 * <p>根据银保监会的文件要求，保险行业财产险公司的车险业务，用户在投保缴费（微信&amp;支付宝&amp;银行卡）之前，必须要完成支付人的实名验证，确保支付人与投保人一致才能缴费。目前实名认证存在四种模式，分别为：中保信模式、上海模式、深圳模式和江苏模式，其中中保信模式和上海模式要求支付机构与实名平台专线对接（已有专线），深圳和江苏是公网对接。因实名平台的接口仅支持有支付牌照的收单机构对接，所以部署一套单独的保险实名认证服务在易宝中台，支撑保险商户业务的正常进行。</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.insurance;


import com.yeepay.yop.sdk.auth.req.AuthorizationReqRegistry;
import com.yeepay.yop.sdk.auth.req.DefaultAuthorizationReqRegistry;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.client.AbstractServiceClientBuilder;

public class InsuranceClientBuilder extends AbstractServiceClientBuilder<InsuranceClientBuilder, InsuranceClientImpl>{

    private static final AuthorizationReqRegistry REGISTRY;

    static {
        REGISTRY = new DefaultAuthorizationReqRegistry();
        REGISTRY.register("realnameAuth", "YOP-SM2-SM3,YOP-RSA2048-SHA256");
        REGISTRY.register("realnameNotify", "YOP-SM2-SM3,YOP-RSA2048-SHA256");
    }

    @Override
    protected AuthorizationReqRegistry authorizationReqRegistry() {
        return REGISTRY;
    }

    @Override
    protected InsuranceClientImpl build(ClientParams params) {
        return new InsuranceClientImpl(params);
    }

    /**
     * @return Create new instance of builder with all defaults set.
     */
    public static InsuranceClientBuilder builder(){
        return new InsuranceClientBuilder();
    }

}
