/*
 * 保险
 * <p>根据银保监会的文件要求，保险行业财产险公司的车险业务，用户在投保缴费（微信&amp;支付宝&amp;银行卡）之前，必须要完成支付人的实名验证，确保支付人与投保人一致才能缴费。目前实名认证存在四种模式，分别为：中保信模式、上海模式、深圳模式和江苏模式，其中中保信模式和上海模式要求支付机构与实名平台专线对接（已有专线），深圳和江苏是公网对接。因实名平台的接口仅支持有支付牌照的收单机构对接，所以部署一套单独的保险实名认证服务在易宝中台，支撑保险商户业务的正常进行。</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.insurance;

import com.yeepay.yop.sdk.client.*;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.insurance.request.*;
import com.yeepay.yop.sdk.service.insurance.response.*;

public class InsuranceClientImpl implements InsuranceClient {

    private final ClientHandler clientHandler;

    InsuranceClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public RealnameAuthResponse realnameAuth(RealnameAuthRequest request) throws YopClientException{
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RequestMarshaller<RealnameAuthRequest> requestMarshaller = RealnameAuthRequestMarshaller.getInstance();
        HttpResponseHandler<RealnameAuthResponse> responseHandler =
                new DefaultHttpResponseHandler<RealnameAuthResponse>(RealnameAuthResponse.class,
                        HttpResponseAnalyzerSupport.getAnalyzerChain());

        return clientHandler.execute(new ClientExecutionParams<RealnameAuthRequest, RealnameAuthResponse>()
                .withInput(request)
                .withRequestMarshaller(requestMarshaller)
                .withResponseHandler(responseHandler));
    }
    @Override
    public RealnameNotifyResponse realnameNotify(RealnameNotifyRequest request) throws YopClientException{
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RequestMarshaller<RealnameNotifyRequest> requestMarshaller = RealnameNotifyRequestMarshaller.getInstance();
        HttpResponseHandler<RealnameNotifyResponse> responseHandler =
                new DefaultHttpResponseHandler<RealnameNotifyResponse>(RealnameNotifyResponse.class,
                        HttpResponseAnalyzerSupport.getAnalyzerChain());

        return clientHandler.execute(new ClientExecutionParams<RealnameNotifyRequest, RealnameNotifyResponse>()
                .withInput(request)
                .withRequestMarshaller(requestMarshaller)
                .withResponseHandler(responseHandler));
    }

    @Override
    public void shutdown() {
        clientHandler.shutdown();
    }

}
