/*
 * 保险
 * <p>根据银保监会的文件要求，保险行业财产险公司的车险业务，用户在投保缴费（微信&amp;支付宝&amp;银行卡）之前，必须要完成支付人的实名验证，确保支付人与投保人一致才能缴费。目前实名认证存在四种模式，分别为：中保信模式、上海模式、深圳模式和江苏模式，其中中保信模式和上海模式要求支付机构与实名平台专线对接（已有专线），深圳和江苏是公网对接。因实名平台的接口仅支持有支付牌照的收单机构对接，所以部署一套单独的保险实名认证服务在易宝中台，支撑保险商户业务的正常进行。</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.insurance.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.internal.RestartableInputStream;
import com.yeepay.yop.sdk.utils.JsonUtils;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;


public class RealnameAuthRequestMarshaller  implements RequestMarshaller<RealnameAuthRequest> {
    private final String serviceName = "Insurance";

    private final String resourcePath = "/rest/v1.0/insurance/realname/auth";

    private final String contentType = "application/json";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<RealnameAuthRequest> marshall(RealnameAuthRequest request) {
        Request<RealnameAuthRequest> internalRequest = new DefaultRequest<RealnameAuthRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        String contentStr = JsonUtils.toJsonString(request.getBody());
        byte[] content = contentStr.getBytes(YopConstants.DEFAULT_CHARSET);
        internalRequest.addHeader(Headers.CONTENT_LENGTH, String.valueOf(content.length));
        internalRequest.setContent(RestartableInputStream.wrap(content));
        internalRequest.setContentType(YopContentType.JSON);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static RealnameAuthRequestMarshaller INSTANCE = new RealnameAuthRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static RealnameAuthRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
