/*
 * 保险
 * <p>根据银保监会的文件要求，保险行业财产险公司的车险业务，用户在投保缴费（微信&amp;支付宝&amp;银行卡）之前，必须要完成支付人的实名验证，确保支付人与投保人一致才能缴费。目前实名认证存在四种模式，分别为：中保信模式、上海模式、深圳模式和江苏模式，其中中保信模式和上海模式要求支付机构与实名平台专线对接（已有专线），深圳和江苏是公网对接。因实名平台的接口仅支持有支付牌照的收单机构对接，所以部署一套单独的保险实名认证服务在易宝中台，支撑保险商户业务的正常进行。</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.insurance.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class RealnameNotifyRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<RealnameNotifyRequest> {
    private final String serviceName = "Insurance";

    private final String resourcePath = "/rest/v1.0/insurance/realname/notify";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<RealnameNotifyRequest> marshall(RealnameNotifyRequest request) {
        Request<RealnameNotifyRequest> internalRequest = new DefaultRequest<RealnameNotifyRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getQueryNo() != null) {
            internalRequest.addParameter("queryNo", PrimitiveMarshallerUtils.marshalling(request.getQueryNo(), "String"));
        }
        if (request.getCustomrNo() != null) {
            internalRequest.addParameter("customrNo", PrimitiveMarshallerUtils.marshalling(request.getCustomrNo(), "String"));
        }
        if (request.getCode() != null) {
            internalRequest.addParameter("code", PrimitiveMarshallerUtils.marshalling(request.getCode(), "String"));
        }
        if (request.getAmount() != null) {
            internalRequest.addParameter("amount", PrimitiveMarshallerUtils.marshalling(request.getAmount(), "String"));
        }
        if (request.getCardNo() != null) {
            internalRequest.addParameter("cardNo", PrimitiveMarshallerUtils.marshalling(request.getCardNo(), "String"));
        }
        if (request.getTradeNo() != null) {
            internalRequest.addParameter("tradeNo", PrimitiveMarshallerUtils.marshalling(request.getTradeNo(), "String"));
        }
        if (request.getDate() != null) {
            internalRequest.addParameter("date", PrimitiveMarshallerUtils.marshalling(request.getDate(), "String"));
        }
        if (request.getSystemNo() != null) {
            internalRequest.addParameter("systemNo", PrimitiveMarshallerUtils.marshalling(request.getSystemNo(), "String"));
        }
        if (request.getTerminalNo() != null) {
            internalRequest.addParameter("terminalNo", PrimitiveMarshallerUtils.marshalling(request.getTerminalNo(), "String"));
        }
        if (request.getPaNo() != null) {
            internalRequest.addParameter("paNo", PrimitiveMarshallerUtils.marshalling(request.getPaNo(), "String"));
        }
        if (request.getValidateSequenceNo() != null) {
            internalRequest.addParameter("validateSequenceNo", PrimitiveMarshallerUtils.marshalling(request.getValidateSequenceNo(), "String"));
        }
        if (request.getRequestType() != null) {
            internalRequest.addParameter("requestType", PrimitiveMarshallerUtils.marshalling(request.getRequestType(), "String"));
        }
        if (request.getWarrantBank() != null) {
            internalRequest.addParameter("warrantBank", PrimitiveMarshallerUtils.marshalling(request.getWarrantBank(), "String"));
        }
        if (request.getAesKey() != null) {
            internalRequest.addParameter("aesKey", PrimitiveMarshallerUtils.marshalling(request.getAesKey(), "String"));
        }
        if (request.getUser() != null) {
            internalRequest.addParameter("user", PrimitiveMarshallerUtils.marshalling(request.getUser(), "String"));
        }
        if (request.getPassword() != null) {
            internalRequest.addParameter("password", PrimitiveMarshallerUtils.marshalling(request.getPassword(), "String"));
        }
        if (request.getProdId() != null) {
            internalRequest.addParameter("prodId", PrimitiveMarshallerUtils.marshalling(request.getProdId(), "String"));
        }
        if (request.getReqType() != null) {
            internalRequest.addParameter("reqType", PrimitiveMarshallerUtils.marshalling(request.getReqType(), "String"));
        }
        if (request.getSysId() != null) {
            internalRequest.addParameter("sysId", PrimitiveMarshallerUtils.marshalling(request.getSysId(), "String"));
        }
        if (request.getRequestUrl() != null) {
            internalRequest.addParameter("requestUrl", PrimitiveMarshallerUtils.marshalling(request.getRequestUrl(), "String"));
        }
        if (request.getMacKey() != null) {
            internalRequest.addParameter("macKey", PrimitiveMarshallerUtils.marshalling(request.getMacKey(), "String"));
        }
        if (request.getEnvironment() != null) {
            internalRequest.addParameter("environment", PrimitiveMarshallerUtils.marshalling(request.getEnvironment(), "String"));
        }
        if (request.getTpdu() != null) {
            internalRequest.addParameter("tpdu", PrimitiveMarshallerUtils.marshalling(request.getTpdu(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static RealnameNotifyRequestMarshaller INSTANCE = new RealnameNotifyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static RealnameNotifyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
