/*
 * 发票服务
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.invoice.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class InfoModifyV10RequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<InfoModifyV10Request> {
    private final String serviceName = "Invoice";

    private final String resourcePath = "/rest/v1.0/invoice/info/modify";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<InfoModifyV10Request> marshall(InfoModifyV10Request request) {
        Request<InfoModifyV10Request> internalRequest = new DefaultRequest<InfoModifyV10Request>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getCustomerRequestNo() != null) {
            internalRequest.addParameter("customerRequestNo", PrimitiveMarshallerUtils.marshalling(request.getCustomerRequestNo(), "String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMode() != null) {
            internalRequest.addParameter("mode", PrimitiveMarshallerUtils.marshalling(request.getMode(), "String"));
        }
        if (request.getInvoiceType() != null) {
            internalRequest.addParameter("invoiceType", PrimitiveMarshallerUtils.marshalling(request.getInvoiceType(), "String"));
        }
        if (request.getInvoiceForm() != null) {
            internalRequest.addParameter("invoiceForm", PrimitiveMarshallerUtils.marshalling(request.getInvoiceForm(), "String"));
        }
        if (request.getLinkman() != null) {
            internalRequest.addParameter("linkman", PrimitiveMarshallerUtils.marshalling(request.getLinkman(), "String"));
        }
        if (request.getLinkmanPhone() != null) {
            internalRequest.addParameter("linkmanPhone", PrimitiveMarshallerUtils.marshalling(request.getLinkmanPhone(), "String"));
        }
        if (request.getPostalAddress() != null) {
            internalRequest.addParameter("postalAddress", PrimitiveMarshallerUtils.marshalling(request.getPostalAddress(), "String"));
        }
        if (request.getPostalCode() != null) {
            internalRequest.addParameter("postalCode", PrimitiveMarshallerUtils.marshalling(request.getPostalCode(), "String"));
        }
        if (request.getTaxpayerId() != null) {
            internalRequest.addParameter("taxpayerId", PrimitiveMarshallerUtils.marshalling(request.getTaxpayerId(), "String"));
        }
        if (request.getInvoicePhone() != null) {
            internalRequest.addParameter("invoicePhone", PrimitiveMarshallerUtils.marshalling(request.getInvoicePhone(), "String"));
        }
        if (request.getInvoiceAddress() != null) {
            internalRequest.addParameter("invoiceAddress", PrimitiveMarshallerUtils.marshalling(request.getInvoiceAddress(), "String"));
        }
        if (request.getBankName() != null) {
            internalRequest.addParameter("bankName", PrimitiveMarshallerUtils.marshalling(request.getBankName(), "String"));
        }
        if (request.getAccountNo() != null) {
            internalRequest.addParameter("accountNo", PrimitiveMarshallerUtils.marshalling(request.getAccountNo(), "String"));
        }
        if (request.getEmail() != null) {
            internalRequest.addParameter("email", PrimitiveMarshallerUtils.marshalling(request.getEmail(), "String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling(request.getRemark(), "String"));
        }
        if (request.getStandardType() != null) {
            internalRequest.addParameter("standardType", PrimitiveMarshallerUtils.marshalling(request.getStandardType(), "String"));
        }
        if (request.getUnit() != null) {
            internalRequest.addParameter("unit", PrimitiveMarshallerUtils.marshalling(request.getUnit(), "String"));
        }
        if (request.getQuantity() != null) {
            internalRequest.addParameter("quantity", PrimitiveMarshallerUtils.marshalling(request.getQuantity(), "Integer"));
        }
        if (request.getInvoiceBusiness() != null) {
            Iterator<String> invoiceBusinessIterator = request.getInvoiceBusiness().iterator();
            while (invoiceBusinessIterator.hasNext()){
                internalRequest.addParameter("invoiceBusiness", PrimitiveMarshallerUtils.marshalling(invoiceBusinessIterator.next(), "String"));
            }
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static InfoModifyV10RequestMarshaller INSTANCE = new InfoModifyV10RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static InfoModifyV10RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
