/*
 * 子商户管理
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class AuthStateQueryV2RequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<AuthStateQueryV2Request> {
    private final String serviceName = "Mer";

    private final String resourcePath = "/rest/v2.0/mer/auth/state/query";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.GET;


    @Override
    public Request<AuthStateQueryV2Request> marshall(AuthStateQueryV2Request request) {
        Request<AuthStateQueryV2Request> internalRequest = new DefaultRequest<AuthStateQueryV2Request>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getReportMerchantNo() != null) {
            internalRequest.addParameter("reportMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getReportMerchantNo(), "String"));
        }
        if (request.getFeeType() != null) {
            internalRequest.addParameter("feeType", PrimitiveMarshallerUtils.marshalling(request.getFeeType(), "String"));
        }
        if (request.getQueryStrategy() != null) {
            internalRequest.addParameter("queryStrategy", PrimitiveMarshallerUtils.marshalling(request.getQueryStrategy(), "String"));
        }
        if (request.getPageNum() != null) {
            internalRequest.addParameter("pageNum", PrimitiveMarshallerUtils.marshalling(request.getPageNum(), "String"));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", PrimitiveMarshallerUtils.marshalling(request.getPageSize(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static AuthStateQueryV2RequestMarshaller INSTANCE = new AuthStateQueryV2RequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static AuthStateQueryV2RequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
