/*
 * 子商户管理
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class MerchantWechatauthApplyRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<MerchantWechatauthApplyRequest> {
    private final String serviceName = "Mer";

    private final String resourcePath = "/rest/v1.0/mer/merchant/wechatauth/apply";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<MerchantWechatauthApplyRequest> marshall(MerchantWechatauthApplyRequest request) {
        Request<MerchantWechatauthApplyRequest> internalRequest = new DefaultRequest<MerchantWechatauthApplyRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getSubMerchantNo() != null) {
            internalRequest.addParameter("subMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getSubMerchantNo(), "String"));
        }
        if (request.getApplicantType() != null) {
            internalRequest.addParameter("applicantType", PrimitiveMarshallerUtils.marshalling(request.getApplicantType(), "String"));
        }
        if (request.getApplicantName() != null) {
            internalRequest.addParameter("applicantName", PrimitiveMarshallerUtils.marshalling(request.getApplicantName(), "String"));
        }
        if (request.getApplicantPhone() != null) {
            internalRequest.addParameter("applicantPhone", trimIfNecessary(PrimitiveMarshallerUtils.marshalling(request.getApplicantPhone(), "String")));
        }
        if (request.getApplicantIdCard() != null) {
            internalRequest.addParameter("applicantIdCard", PrimitiveMarshallerUtils.marshalling(request.getApplicantIdCard(), "String"));
        }
        if (request.getTransactorInfo() != null) {
            internalRequest.addParameter("transactorInfo", PrimitiveMarshallerUtils.marshalling(request.getTransactorInfo(), "String"));
        }
        if (request.getIdentificationType() != null) {
            internalRequest.addParameter("identificationType", PrimitiveMarshallerUtils.marshalling(request.getIdentificationType(), "String"));
        }
        if (request.getIdentificationFrontCopy() != null) {
            internalRequest.addParameter("identificationFrontCopy", PrimitiveMarshallerUtils.marshalling(request.getIdentificationFrontCopy(), "String"));
        }
        if (request.getIdentificationBackCopy() != null) {
            internalRequest.addParameter("identificationBackCopy", PrimitiveMarshallerUtils.marshalling(request.getIdentificationBackCopy(), "String"));
        }
        if (request.getIdentificationValidDate() != null) {
            internalRequest.addParameter("identificationValidDate", PrimitiveMarshallerUtils.marshalling(request.getIdentificationValidDate(), "String"));
        }
        if (request.getIdentificationAddress() != null) {
            internalRequest.addParameter("identificationAddress", PrimitiveMarshallerUtils.marshalling(request.getIdentificationAddress(), "String"));
        }
        if (request.getCertCopy() != null) {
            internalRequest.addParameter("certCopy", PrimitiveMarshallerUtils.marshalling(request.getCertCopy(), "String"));
        }
        if (request.getCompanyAddress() != null) {
            internalRequest.addParameter("companyAddress", PrimitiveMarshallerUtils.marshalling(request.getCompanyAddress(), "String"));
        }
        if (request.getLicenceValidDate() != null) {
            internalRequest.addParameter("licenceValidDate", PrimitiveMarshallerUtils.marshalling(request.getLicenceValidDate(), "String"));
        }
        if (request.getIsFinanceInstitution() != null) {
            internalRequest.addParameter("isFinanceInstitution", PrimitiveMarshallerUtils.marshalling(request.getIsFinanceInstitution(), "Boolean"));
        }
        if (request.getFinanceInstitutionInfo() != null) {
            internalRequest.addParameter("financeInstitutionInfo", PrimitiveMarshallerUtils.marshalling(request.getFinanceInstitutionInfo(), "String"));
        }
        if (request.getCertType() != null) {
            internalRequest.addParameter("certType", PrimitiveMarshallerUtils.marshalling(request.getCertType(), "String"));
        }
        if (request.getCertNumber() != null) {
            internalRequest.addParameter("certNumber", PrimitiveMarshallerUtils.marshalling(request.getCertNumber(), "String"));
        }
        if (request.getCompanyProveCopy() != null) {
            internalRequest.addParameter("companyProveCopy", PrimitiveMarshallerUtils.marshalling(request.getCompanyProveCopy(), "String"));
        }
        if (request.getOwner() != null) {
            internalRequest.addParameter("owner", PrimitiveMarshallerUtils.marshalling(request.getOwner(), "Boolean"));
        }
        if (request.getUboInfoList() != null) {
            internalRequest.addParameter("uboInfoList", PrimitiveMarshallerUtils.marshalling(request.getUboInfoList(), "String"));
        }
        if (request.getReportFee() != null) {
            internalRequest.addParameter("reportFee", PrimitiveMarshallerUtils.marshalling(request.getReportFee(), "String"));
        }
        if (request.getChannelId() != null) {
            internalRequest.addParameter("channelId", PrimitiveMarshallerUtils.marshalling(request.getChannelId(), "String"));
        }
        if (request.getMicroBizType() != null) {
            internalRequest.addParameter("microBizType", PrimitiveMarshallerUtils.marshalling(request.getMicroBizType(), "String"));
        }
        if (request.getStoreName() != null) {
            internalRequest.addParameter("storeName", PrimitiveMarshallerUtils.marshalling(request.getStoreName(), "String"));
        }
        if (request.getStoreAddressCode() != null) {
            internalRequest.addParameter("storeAddressCode", PrimitiveMarshallerUtils.marshalling(request.getStoreAddressCode(), "String"));
        }
        if (request.getStoreHeaderCopy() != null) {
            internalRequest.addParameter("storeHeaderCopy", PrimitiveMarshallerUtils.marshalling(request.getStoreHeaderCopy(), "String"));
        }
        if (request.getStoreIndoorCopy() != null) {
            internalRequest.addParameter("storeIndoorCopy", PrimitiveMarshallerUtils.marshalling(request.getStoreIndoorCopy(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static MerchantWechatauthApplyRequestMarshaller INSTANCE = new MerchantWechatauthApplyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static MerchantWechatauthApplyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
