/*
 * 子商户管理
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class ReceiverApplyRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<ReceiverApplyRequest> {
    private final String serviceName = "Mer";

    private final String resourcePath = "/rest/v1.0/mer/receiver/apply";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<ReceiverApplyRequest> marshall(ReceiverApplyRequest request) {
        Request<ReceiverApplyRequest> internalRequest = new DefaultRequest<ReceiverApplyRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling(request.getRequestNo(), "String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", trimIfNecessary(PrimitiveMarshallerUtils.marshalling(request.getNotifyUrl(), "String")));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getType() != null) {
            internalRequest.addParameter("type", PrimitiveMarshallerUtils.marshalling(request.getType().getValue(), "String"));
        }
        if (request.getReceiverName() != null) {
            internalRequest.addParameter("receiverName", PrimitiveMarshallerUtils.marshalling(request.getReceiverName(), "String"));
        }
        if (request.getLabel() != null) {
            internalRequest.addParameter("label", PrimitiveMarshallerUtils.marshalling(request.getLabel(), "String"));
        }
        if (request.getLicenceNo() != null) {
            internalRequest.addParameter("licenceNo", PrimitiveMarshallerUtils.marshalling(request.getLicenceNo(), "String"));
        }
        if (request.getMobile() != null) {
            internalRequest.addParameter("mobile", PrimitiveMarshallerUtils.marshalling(request.getMobile(), "String"));
        }
        if (request.getLegalName() != null) {
            internalRequest.addParameter("legalName", PrimitiveMarshallerUtils.marshalling(request.getLegalName(), "String"));
        }
        if (request.getLegalLicenceNo() != null) {
            internalRequest.addParameter("legalLicenceNo", PrimitiveMarshallerUtils.marshalling(request.getLegalLicenceNo(), "String"));
        }
        if (request.getBankCode() != null) {
            internalRequest.addParameter("bankCode", PrimitiveMarshallerUtils.marshalling(request.getBankCode(), "String"));
        }
        if (request.getBankCardNo() != null) {
            internalRequest.addParameter("bankCardNo", PrimitiveMarshallerUtils.marshalling(request.getBankCardNo(), "String"));
        }
        if (request.getSettlementProduct() != null) {
            internalRequest.addParameter("settlementProduct", PrimitiveMarshallerUtils.marshalling(request.getSettlementProduct().getValue(), "String"));
        }
        if (request.getSettlementDate() != null) {
            internalRequest.addParameter("settlementDate", PrimitiveMarshallerUtils.marshalling(request.getSettlementDate(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static ReceiverApplyRequestMarshaller INSTANCE = new ReceiverApplyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static ReceiverApplyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
