/*
 * 网银支付
 * <p>提供网银支付相关服务（支付下单等功能）</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.netpay;

import com.yeepay.yop.sdk.client.*;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.netpay.request.*;
import com.yeepay.yop.sdk.service.netpay.response.*;

public class NetpayClientImpl implements NetpayClient {

    private final ClientHandler clientHandler;

    NetpayClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public OrderResponse order(OrderRequest request) throws YopClientException{
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RequestMarshaller<OrderRequest> requestMarshaller = OrderRequestMarshaller.getInstance();
        HttpResponseHandler<OrderResponse> responseHandler =
                new DefaultHttpResponseHandler<OrderResponse>(OrderResponse.class,
                        HttpResponseAnalyzerSupport.getAnalyzerChain());

        return clientHandler.execute(new ClientExecutionParams<OrderRequest, OrderResponse>()
                .withInput(request)
                .withRequestMarshaller(requestMarshaller)
                .withResponseHandler(responseHandler));
    }
    @Override
    public OrderSdkPayOrderResponse orderSdkPayOrder(OrderSdkPayOrderRequest request) throws YopClientException{
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RequestMarshaller<OrderSdkPayOrderRequest> requestMarshaller = OrderSdkPayOrderRequestMarshaller.getInstance();
        HttpResponseHandler<OrderSdkPayOrderResponse> responseHandler =
                new DefaultHttpResponseHandler<OrderSdkPayOrderResponse>(OrderSdkPayOrderResponse.class,
                        HttpResponseAnalyzerSupport.getAnalyzerChain());

        return clientHandler.execute(new ClientExecutionParams<OrderSdkPayOrderRequest, OrderSdkPayOrderResponse>()
                .withInput(request)
                .withRequestMarshaller(requestMarshaller)
                .withResponseHandler(responseHandler));
    }

    @Override
    public void shutdown() {
        clientHandler.shutdown();
    }

}
