/*
 * 网银支付
 * <p>提供网银支付相关服务（支付下单等功能）</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.netpay.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class OrderRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<OrderRequest> {
    private final String serviceName = "Netpay";

    private final String resourcePath = "/rest/v1.0/netpay/order";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<OrderRequest> marshall(OrderRequest request) {
        Request<OrderRequest> internalRequest = new DefaultRequest<OrderRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling(request.getOrderId(), "String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling(request.getOrderAmount(), "BigDecimal"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling(request.getExpiredTime(), "String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling(request.getNotifyUrl(), "String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling(request.getMemo(), "String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling(request.getGoodsName(), "String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling(request.getFundProcessType(), "String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling(request.getCardType(), "String"));
        }
        if (request.getBankAccountType() != null) {
            internalRequest.addParameter("bankAccountType", PrimitiveMarshallerUtils.marshalling(request.getBankAccountType(), "String"));
        }
        if (request.getBankCode() != null) {
            internalRequest.addParameter("bankCode", PrimitiveMarshallerUtils.marshalling(request.getBankCode(), "String"));
        }
        if (request.getTerminalType() != null) {
            internalRequest.addParameter("terminalType", PrimitiveMarshallerUtils.marshalling(request.getTerminalType(), "String"));
        }
        if (request.getPayerIp() != null) {
            internalRequest.addParameter("payerIp", PrimitiveMarshallerUtils.marshalling(request.getPayerIp(), "String"));
        }
        if (request.getCsNotifyUrl() != null) {
            internalRequest.addParameter("csNotifyUrl", PrimitiveMarshallerUtils.marshalling(request.getCsNotifyUrl(), "String"));
        }
        if (request.getBusinessInfo() != null) {
            internalRequest.addParameter("businessInfo", PrimitiveMarshallerUtils.marshalling(request.getBusinessInfo(), "String"));
        }
        if (request.getReturnUrl() != null) {
            internalRequest.addParameter("returnUrl", PrimitiveMarshallerUtils.marshalling(request.getReturnUrl(), "String"));
        }
        if (request.getOrderType() != null) {
            internalRequest.addParameter("orderType", PrimitiveMarshallerUtils.marshalling(request.getOrderType(), "String"));
        }
        if (request.getPayerAccountName() != null) {
            internalRequest.addParameter("payerAccountName", PrimitiveMarshallerUtils.marshalling(request.getPayerAccountName(), "String"));
        }
        if (request.getPayerAccountNo() != null) {
            internalRequest.addParameter("payerAccountNo", PrimitiveMarshallerUtils.marshalling(request.getPayerAccountNo(), "String"));
        }
        if (request.getCommercePlatform() != null) {
            internalRequest.addParameter("commercePlatform", PrimitiveMarshallerUtils.marshalling(request.getCommercePlatform(), "String"));
        }
        if (request.getPyeeBankAccountType() != null) {
            internalRequest.addParameter("pyeeBankAccountType", PrimitiveMarshallerUtils.marshalling(request.getPyeeBankAccountType(), "String"));
        }
        if (request.getPyeeBankCode() != null) {
            internalRequest.addParameter("pyeeBankCode", PrimitiveMarshallerUtils.marshalling(request.getPyeeBankCode(), "String"));
        }
        if (request.getPyeeAccountName() != null) {
            internalRequest.addParameter("pyeeAccountName", PrimitiveMarshallerUtils.marshalling(request.getPyeeAccountName(), "String"));
        }
        if (request.getPyeeAccountNo() != null) {
            internalRequest.addParameter("pyeeAccountNo", PrimitiveMarshallerUtils.marshalling(request.getPyeeAccountNo(), "String"));
        }
        if (request.getMerGoodsInfoList() != null) {
            internalRequest.addParameter("merGoodsInfoList", PrimitiveMarshallerUtils.marshalling(request.getMerGoodsInfoList(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static OrderRequestMarshaller INSTANCE = new OrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static OrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
