/*
 * 线下业务
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.offline.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class CreateShopRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<CreateShopRequest> {
    private final String serviceName = "Offline";

    private final String resourcePath = "/rest/v1.0/offline/create-shop";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<CreateShopRequest> marshall(CreateShopRequest request) {
        Request<CreateShopRequest> internalRequest = new DefaultRequest<CreateShopRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getAddress() != null) {
            internalRequest.addParameter("address", PrimitiveMarshallerUtils.marshalling(request.getAddress(), "String"));
        }
        if (request.getProvince() != null) {
            internalRequest.addParameter("province", PrimitiveMarshallerUtils.marshalling(request.getProvince(), "String"));
        }
        if (request.getCity() != null) {
            internalRequest.addParameter("city", PrimitiveMarshallerUtils.marshalling(request.getCity(), "String"));
        }
        if (request.getDistrict() != null) {
            internalRequest.addParameter("district", PrimitiveMarshallerUtils.marshalling(request.getDistrict(), "String"));
        }
        if (request.getMobile() != null) {
            internalRequest.addParameter("mobile", PrimitiveMarshallerUtils.marshalling(request.getMobile(), "String"));
        }
        if (request.getShopName() != null) {
            internalRequest.addParameter("shopName", PrimitiveMarshallerUtils.marshalling(request.getShopName(), "String"));
        }
        if (request.getLinkman() != null) {
            internalRequest.addParameter("linkman", PrimitiveMarshallerUtils.marshalling(request.getLinkman(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getCustomizeShopNo() != null) {
            internalRequest.addParameter("customizeShopNo", PrimitiveMarshallerUtils.marshalling(request.getCustomizeShopNo(), "String"));
        }
        if (request.getRealShop() != null) {
            internalRequest.addParameter("realShop", PrimitiveMarshallerUtils.marshalling(request.getRealShop(), "Boolean"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static CreateShopRequestMarshaller INSTANCE = new CreateShopRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static CreateShopRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
