/*
 * pos
 * <p>pos对外接口</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.pos.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class InstallPosWithProductRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<InstallPosWithProductRequest> {
    private final String serviceName = "Pos";

    private final String resourcePath = "/rest/v1.0/pos/install-pos-with-product";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<InstallPosWithProductRequest> marshall(InstallPosWithProductRequest request) {
        Request<InstallPosWithProductRequest> internalRequest = new DefaultRequest<InstallPosWithProductRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getCustomerNumber() != null) {
            internalRequest.addParameter("customer_number", PrimitiveMarshallerUtils.marshalling(request.getCustomerNumber(), "String"));
        }
        if (request.getShopStr() != null) {
            internalRequest.addParameter("shopStr", PrimitiveMarshallerUtils.marshalling(request.getShopStr(), "String"));
        }
        if (request.getPosStr() != null) {
            internalRequest.addParameter("posStr", PrimitiveMarshallerUtils.marshalling(request.getPosStr(), "String"));
        }
        if (request.getProductCode() != null) {
            internalRequest.addParameter("product_code", PrimitiveMarshallerUtils.marshalling(request.getProductCode(), "String"));
        }
        if (request.getExternalMcc() != null) {
            internalRequest.addParameter("external_mcc", PrimitiveMarshallerUtils.marshalling(request.getExternalMcc(), "String"));
        }
        if (request.getCustomerType() != null) {
            internalRequest.addParameter("customer_type", PrimitiveMarshallerUtils.marshalling(request.getCustomerType(), "String"));
        }
        if (request.getShopList() != null) {
            Iterator<String> shopListIterator = request.getShopList().iterator();
            while (shopListIterator.hasNext()){
                internalRequest.addParameter("shopList", PrimitiveMarshallerUtils.marshalling(shopListIterator.next(), "String"));
            }
        }
        if (request.getPosList() != null) {
            Iterator<String> posListIterator = request.getPosList().iterator();
            while (posListIterator.hasNext()){
                internalRequest.addParameter("posList", PrimitiveMarshallerUtils.marshalling(posListIterator.next(), "String"));
            }
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static InstallPosWithProductRequestMarshaller INSTANCE = new InstallPosWithProductRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static InstallPosWithProductRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
