/*
 * 电信支付
 * <p>电信行业线易宝通应用-支付服务</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.tel_pay.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class QrcodeQueryRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<QrcodeQueryRequest> {
    private final String serviceName = "TelPay";

    private final String resourcePath = "/rest/v1.0/tel-pay/qrcode/query";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.GET;


    @Override
    public Request<QrcodeQueryRequest> marshall(QrcodeQueryRequest request) {
        Request<QrcodeQueryRequest> internalRequest = new DefaultRequest<QrcodeQueryRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling(request.getParentMerchantNo(), "String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling(request.getMerchantNo(), "String"));
        }
        if (request.getRequestId() != null) {
            internalRequest.addParameter("requestId", PrimitiveMarshallerUtils.marshalling(request.getRequestId(), "String"));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", PrimitiveMarshallerUtils.marshalling(request.getPageSize(), "Integer"));
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", PrimitiveMarshallerUtils.marshalling(request.getPageNo(), "Integer"));
        }
        if (request.getQrId() != null) {
            internalRequest.addParameter("qrId", PrimitiveMarshallerUtils.marshalling(request.getQrId(), "String"));
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", PrimitiveMarshallerUtils.marshalling(request.getStartTime(), "String"));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", PrimitiveMarshallerUtils.marshalling(request.getEndTime(), "String"));
        }
        if (request.getQrStatus() != null) {
            internalRequest.addParameter("qrStatus", PrimitiveMarshallerUtils.marshalling(request.getQrStatus(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static QrcodeQueryRequestMarshaller INSTANCE = new QrcodeQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static QrcodeQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
