/*
 * 一站式服务套件
 * <p class=\"p1\">一站式服务套件</p>
 *
 * OpenAPI spec version: 1.0
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.yeepay.yop.sdk.service.yop.request;

import com.yeepay.yop.sdk.YopConstants;
import com.yeepay.yop.sdk.http.Headers;
import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import java.util.Map;
import java.util.UUID;
import java.util.Iterator;
import org.apache.commons.lang3.BooleanUtils;
import com.yeepay.yop.sdk.service.base.request.BaseRequestMarshaller;


public class Oauth2ReportKeyRequestMarshaller extends BaseRequestMarshaller implements RequestMarshaller<Oauth2ReportKeyRequest> {
    private final String serviceName = "Yop";

    private final String resourcePath = "/rest/v1.0/yop/oauth2/report-key";

    private final String contentType = "application/x-www-form-urlencoded";

    private final HttpMethodName httpMethodName = HttpMethodName.POST;


    @Override
    public Request<Oauth2ReportKeyRequest> marshall(Oauth2ReportKeyRequest request) {
        Request<Oauth2ReportKeyRequest> internalRequest = new DefaultRequest<Oauth2ReportKeyRequest>(request, serviceName);
        internalRequest.setResourcePath(resourcePath);
        internalRequest.setHttpMethod(httpMethodName);
        if (!internalRequest.getHeaders().containsKey(Headers.YOP_REQUEST_ID)) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader(Headers.YOP_REQUEST_ID, requestId);
        }
        Map<String, String> customerHeaders = request.getHeaders();
        if (customerHeaders != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, customerHeaders.get(key));
            }
        }
        if (request.getKeyType() != null) {
            internalRequest.addParameter("keyType", PrimitiveMarshallerUtils.marshalling(request.getKeyType(), "String"));
        }
        if (request.getKey() != null) {
            internalRequest.addParameter("key", PrimitiveMarshallerUtils.marshalling(request.getKey(), "String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader(Headers.CONTENT_TYPE, internalRequest.getContentType().getValue());
        super.marshall(internalRequest, request.get_extParamMap());
        return internalRequest;
    }


    private static class CacheInstanceHolder {
        public static Oauth2ReportKeyRequestMarshaller INSTANCE = new Oauth2ReportKeyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }

    public static Oauth2ReportKeyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }
}
