/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.dc.ovopark.open.platform.api.rest;

import com.ovopark.dc.ovopark.open.platform.api.rest.RestCommon;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;
import org.springframework.context.MessageSource;

public class RestResponse<T>
implements Serializable {
    private static final long serialVersionUID = -7466094708162635482L;
    public int code = 0;
    public String codename = "SUCCESS";
    public String result = "\u6210\u529f";
    public boolean isError = false;
    public T data;
    public String traceId;

    public static <T> RestResponse<T> error(Integer code, String codename, String result, String traceId) {
        RestResponse<T> response = new RestResponse<T>();
        response.code = code;
        response.isError = true;
        response.result = result;
        response.codename = String.join((CharSequence)",", codename, result);
        response.traceId = traceId;
        return response;
    }

    public static <T> RestResponse<T> error(Integer code, String codename, String result) {
        RestResponse<T> response = new RestResponse<T>();
        response.code = code;
        response.isError = true;
        response.result = result;
        response.codename = String.join((CharSequence)",", codename, result);
        return response;
    }

    public static <T> RestResponse<T> error(Integer code, String codename) {
        return RestResponse.error(code, codename, "\u5931\u8d25");
    }

    public static <T> RestResponse<T> error(RestCommon.RestCommonEnum restCommonEnum) {
        return RestResponse.error(restCommonEnum.code, restCommonEnum.desc);
    }

    public static <T> RestResponse<T> error(RestCommon.RestCommonEnum restCommonEnum, String msg) {
        return RestResponse.error(restCommonEnum.code, restCommonEnum.desc, msg);
    }

    public static <T> RestResponse<T> error(RestCommon.RestCommonEnum restCommonEnum, String msg, Locale locale, MessageSource messageSource, String traceId) {
        RestResponse<T> response = new RestResponse<T>();
        response.code = restCommonEnum.code;
        response.isError = true;
        if (Objects.nonNull(messageSource) && Objects.nonNull(locale)) {
            if (msg.startsWith("{") && msg.endsWith("}")) {
                String string = msg.replace("\\{", "");
                msg = string.replace("}", "");
                response.result = msg = messageSource.getMessage(msg, null, locale);
            } else {
                response.result = msg;
            }
            response.codename = String.join((CharSequence)",", messageSource.getMessage(restCommonEnum.i18nKey, null, locale), msg);
        } else {
            response.result = msg;
            response.codename = String.join((CharSequence)",", restCommonEnum.desc, msg);
        }
        response.traceId = traceId;
        return response;
    }

    public static <T> RestResponse<T> success() {
        RestResponse<T> response = new RestResponse<T>();
        response.isError = false;
        response.result = "\u6210\u529f";
        response.data = null;
        return response;
    }

    public static <T> RestResponse<T> success(String traceId) {
        RestResponse<T> response = new RestResponse<T>();
        response.isError = false;
        response.result = "\u6210\u529f";
        response.data = null;
        response.traceId = traceId;
        return response;
    }

    public static <T> RestResponse<T> success(T data) {
        RestResponse<T> response = new RestResponse<T>();
        response.isError = false;
        response.result = "\u6210\u529f";
        response.data = data;
        return response;
    }

    public static <T> RestResponse<T> success(T data, String traceId) {
        RestResponse<T> response = new RestResponse<T>();
        response.isError = false;
        response.result = "\u6210\u529f";
        response.data = data;
        response.traceId = traceId;
        return response;
    }

    public int getCode() {
        return this.code;
    }

    public String getCodename() {
        return this.codename;
    }

    public String getResult() {
        return this.result;
    }

    public boolean isError() {
        return this.isError;
    }

    public T getData() {
        return this.data;
    }

    public String getTraceId() {
        return this.traceId;
    }
}

