package com.ovopark.eventhub.sdk.internal;


import com.ovopark.eventhub.sdk.model.internal.DeviceTopNModel;
import com.ovopark.eventhub.sdk.model.internal.EventOnOffModel;
import com.ovopark.module.shared.BaseResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(value = "eventhub-state"
//        ,url = "127.0.0.1:13699"
)
public interface EventStateApi {


    @PostMapping("/eventhub-state/feign/func/deviceTopN/put")
    public BaseResult<Boolean> deviceTopNPut(@RequestBody DeviceTopNModel deviceTopNModel);

    @GetMapping("/eventhub-state/feign/func/deviceTopN/get")
    public BaseResult<List<DeviceTopNModel>> deviceTopNGet(@RequestParam("userId") int userId
            , @RequestParam("size") int size);

    @GetMapping("/eventhub-state/feign/func/deviceEvent/get")
    public BaseResult<EventOnOffModel> deviceEventGet(@RequestParam("deviceId") int deviceId);

    @PostMapping("/eventhub-state/feign/func/deviceEvent/put")
    public BaseResult<Boolean> deviceEventPut(@RequestParam("deviceId") int deviceId
            , @RequestParam("moving") boolean moving
    );
}
