/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.eventhub.sdk;

import com.ovopark.eventhub.sdk.DeviceLogApi;
import com.ovopark.eventhub.sdk.DeviceLogEventService;
import com.ovopark.eventhub.sdk.model.OpeLogPut;
import com.ovopark.eventhub.sdk.model.PlayLogPut;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleDeviceLogEventAsyncService
implements DeviceLogEventService {
    @Autowired
    private DeviceLogApi deviceLogApi;
    static final TimingWheel timingWheel = new TimingWheel(SimpleDeviceLogEventAsyncService.class.getName());
    static final ExecutorService executorService = Util.defaultExecutorService((String)"device-log-push", (int)16, (int)100000, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());

    @Override
    public void playLogPut(final PlayLogPut playLogPut) {
        if (playLogPut == null) {
            return;
        }
        executorService.execute(Util.catchRunnable(() -> {
            try {
                this.deviceLogApi.playLogPut(playLogPut);
            }
            catch (Exception e) {
                final long next = System.currentTimeMillis() + 180000L;
                timingWheel.delay(new DelayTask(){

                    public long triggerTimeMs() {
                        return next;
                    }

                    public Comparable taskId() {
                        return Long.valueOf(playLogPut.getTime());
                    }

                    public Runnable task() {
                        return () -> executorService.execute(Util.catchRunnable(() -> SimpleDeviceLogEventAsyncService.this.deviceLogApi.playLogPut(playLogPut)));
                    }
                });
            }
        }));
    }

    @Override
    public void opeLogPut(final OpeLogPut opeLogPut) {
        if (opeLogPut == null) {
            return;
        }
        executorService.execute(Util.catchRunnable(() -> {
            try {
                this.deviceLogApi.opeLogPut(opeLogPut);
            }
            catch (Exception e) {
                final long next = System.currentTimeMillis() + 180000L;
                timingWheel.delay(new DelayTask(){

                    public long triggerTimeMs() {
                        return next;
                    }

                    public Comparable taskId() {
                        return Long.valueOf(opeLogPut.getTime());
                    }

                    public Runnable task() {
                        return () -> executorService.execute(Util.catchRunnable(() -> SimpleDeviceLogEventAsyncService.this.deviceLogApi.opeLogPut(opeLogPut)));
                    }
                });
            }
        }));
    }
}

