package com.ovopark.eventhub.sdk;

import com.ovopark.eventhub.sdk.model.DeviceLogReadModel;
import com.ovopark.eventhub.sdk.model.DeviceLogReadQuery;
import com.ovopark.eventhub.sdk.model.OpeLogPut;
import com.ovopark.eventhub.sdk.model.PlayLogPut;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.PageModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value = "eventhub-control")
public interface DeviceLogApi {

    @PostMapping("/eventhub-control/feign/device-log/play/put")
    BaseResult<Boolean> playLogPut(@RequestBody PlayLogPut playLogPut);

    @PostMapping("/eventhub-control/feign/device-log/ope/put")
    BaseResult<Boolean> opeLogPut(@RequestBody OpeLogPut opeLogPut);

    @PostMapping("/eventhub-control/feign/device-log/ope/search")
    BaseResult<PageModel<DeviceLogReadModel>> search(@RequestBody DeviceLogReadQuery deviceLogReadQuery);
}
