/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.i18hub.sdk.client;

import com.ovopark.i18hub.sdk.client.DynamicMessageSource;
import com.ovopark.i18hub.sdk.client.I18ModuleDef;
import com.ovopark.i18hub.sdk.client.Link2I18Transport;
import com.ovopark.i18hub.sdk.model.AppLang;
import com.ovopark.i18hub.sdk.model.FileVer;
import com.ovopark.i18hub.sdk.model.I18Request;
import com.ovopark.i18hub.sdk.model.I18Response;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.Util;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.support.ResourceBundleMessageSource;

class SimpleDynamicMessageSource
extends ResourceBundleMessageSource
implements InitializingBean,
DynamicMessageSource {
    private static final Logger log = LoggerFactory.getLogger(SimpleDynamicMessageSource.class);
    public static final int refreshTimeSec = Config.ConfigPriority.option().getInt("i18hub.client.module.refreshTimeSec", Integer.valueOf(5));
    @Value(value="${spring.application.name}")
    private String app;
    private final Map<Locale, PropertiesFile> propertiesFileMap = new ConcurrentHashMap<Locale, PropertiesFile>();
    final I18ModuleDef i18ModuleDef;
    final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    final Link2I18Transport link2I18Transport;

    public SimpleDynamicMessageSource(I18ModuleDef i18ModuleDef, Link2I18Transport link2I18Transport) {
        this.i18ModuleDef = i18ModuleDef;
        this.link2I18Transport = link2I18Transport;
    }

    protected String resolveCodeWithoutArguments(String code, Locale locale) {
        PropertiesFile.KeyHolder found;
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null && (found = (PropertiesFile.KeyHolder)propertiesFile.i18KeyMap.get(code)) != null) {
            return found.message;
        }
        return super.resolveCodeWithoutArguments(code, locale);
    }

    protected MessageFormat resolveCode(String code, Locale locale) {
        PropertiesFile.KeyHolder found;
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null && (found = (PropertiesFile.KeyHolder)propertiesFile.i18KeyMap.get(code)) != null) {
            return found.messageFormat;
        }
        return super.resolveCode(code, locale);
    }

    synchronized void refresh(String module, String ver, Locale locale, Properties properties, String md5) {
        if (this.sameMD5If(locale, md5)) {
            return;
        }
        this.refresh0(module, ver, locale, () -> properties, md5);
    }

    private void refresh0(String module, String ver, Locale locale, Supplier<Properties> propertiesSupplier, String md5) {
        PropertiesFile propertiesFile = new PropertiesFile(md5);
        try {
            propertiesSupplier.get().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, c) -> {
                try {
                    propertiesFile.i18KeyMap.put((String)k, new PropertiesFile.KeyHolder((String)c, locale));
                }
                catch (Exception e) {
                    log.error(k + " = " + c);
                    log.error(e.getMessage(), (Throwable)e);
                    throw Util.convert2RuntimeException((Throwable)e);
                }
            }));
            this.propertiesFileMap.put(locale, propertiesFile);
            log.info("load i18 properties: " + module + ":" + ver + ":" + locale + ", " + md5);
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", " + locale, (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    private boolean sameMD5If(Locale locale, String md5) {
        PropertiesFile propertiesFile = this.propertiesFileMap.get(locale);
        if (propertiesFile != null) {
            return propertiesFile.md5.equals(md5);
        }
        return false;
    }

    synchronized void refresh(String module, String ver, Locale locale, String fileContent, String md5) {
        try {
            if (this.sameMD5If(locale, md5)) {
                return;
            }
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(Util.utf8((String)fileContent)));
            this.refresh0(module, ver, locale, () -> properties, md5);
        }
        catch (Exception e) {
            log.error(e.getMessage() + ", " + locale, (Throwable)e);
            throw Util.convert2RuntimeException((Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.setBasenames(new String[]{"i18n/" + this.i18ModuleDef.module() + "/" + this.i18ModuleDef.ver() + "/" + this.i18ModuleDef.ver(), "i18n/" + this.i18ModuleDef.module() + "/base/base"});
        this.setDefaultEncoding("utf-8");
        this.setUseCodeAsDefaultMessage(this.i18ModuleDef.useCodeAsDefaultMessage());
        this.setDefaultLocale(this.i18ModuleDef.defaultLocale());
        Util.schedule((ScheduledExecutorService)this.scheduledExecutorService, (Util.CatchRunnable)new Util.CatchRunnable(){

            public void run() throws Exception {
                I18Request i18Request = new I18Request();
                i18Request.setApp(SimpleDynamicMessageSource.this.app);
                i18Request.setModule(SimpleDynamicMessageSource.this.i18ModuleDef.module());
                i18Request.setVer(Util.isEmpty((CharSequence)SimpleDynamicMessageSource.this.i18ModuleDef.ver()) ? "base" : SimpleDynamicMessageSource.this.i18ModuleDef.ver());
                ArrayList<AppLang> appLangList = new ArrayList<AppLang>();
                for (Locale locale : FileVer.activeLocaleList()) {
                    AppLang appLang = new AppLang();
                    appLang.setLocale(locale);
                    PropertiesFile propertiesFile = (PropertiesFile)SimpleDynamicMessageSource.this.propertiesFileMap.get(locale);
                    appLang.setMd5(propertiesFile == null ? null : propertiesFile.md5);
                    appLangList.add(appLang);
                }
                i18Request.setAppLangList(appLangList);
                I18Response i18Response = SimpleDynamicMessageSource.this.link2I18Transport.request(i18Request);
                if (i18Response.isSuccess() && Util.isNotEmpty((Collection)i18Response.getAppLangList())) {
                    for (AppLang appLang : i18Response.getAppLangList()) {
                        try {
                            SimpleDynamicMessageSource.this.refresh(i18Request.getModule(), i18Request.getVer(), appLang.getLocale(), appLang.getContent(), appLang.getMd5());
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }, (long)refreshTimeSec, (TimeUnit)TimeUnit.SECONDS, t -> true, () -> true);
    }

    static class PropertiesFile {
        private final String md5;
        private final Map<String, KeyHolder> i18KeyMap = new ConcurrentHashMap<String, KeyHolder>();

        public PropertiesFile(String md5) {
            this.md5 = md5;
        }

        static class KeyHolder {
            private final String message;
            private final MessageFormat messageFormat;

            public KeyHolder(String message, Locale locale) {
                this.message = message;
                this.messageFormat = new MessageFormat(message, locale);
            }

            public String getMessage() {
                return this.message;
            }

            public MessageFormat getMessageFormat() {
                return this.messageFormat;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeyHolder)) {
                    return false;
                }
                KeyHolder other = (KeyHolder)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$message = this.getMessage();
                String other$message = other.getMessage();
                if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                    return false;
                }
                MessageFormat this$messageFormat = this.getMessageFormat();
                MessageFormat other$messageFormat = other.getMessageFormat();
                return !(this$messageFormat == null ? other$messageFormat != null : !((Object)this$messageFormat).equals(other$messageFormat));
            }

            protected boolean canEqual(Object other) {
                return other instanceof KeyHolder;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $message = this.getMessage();
                result = result * 59 + ($message == null ? 43 : $message.hashCode());
                MessageFormat $messageFormat = this.getMessageFormat();
                result = result * 59 + ($messageFormat == null ? 43 : ((Object)$messageFormat).hashCode());
                return result;
            }

            public String toString() {
                return "SimpleDynamicMessageSource.PropertiesFile.KeyHolder(message=" + this.getMessage() + ", messageFormat=" + this.getMessageFormat() + ")";
            }
        }
    }
}

