/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.i18hub.sdk.client;

import com.ovopark.i18hub.sdk.client.ClientNode;
import com.ovopark.i18hub.sdk.client.ClientNodeConfig;
import com.ovopark.i18hub.sdk.client.ClientNodeProvider;
import com.ovopark.kernel.shared.NetUtil;
import com.ovopark.kernel.shared.Util;
import java.net.InetAddress;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;

public class NacosNodeProvider
implements ClientNodeProvider {
    @Autowired
    private ServiceInstance serviceInstance;
    @Autowired
    private ClientNodeConfig clientNodeConfig;
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${spring.application.name}")
    private String app;

    @Override
    public ClientNode clientNode() {
        int port;
        URI uri = this.serviceInstance.getUri();
        String registerIp = this.clientNodeConfig.ip();
        if (Util.isEmpty((CharSequence)registerIp)) {
            if (this.clientNodeConfig.useNacosIp()) {
                registerIp = uri.getHost();
            } else {
                InetAddress localAddress = NetUtil.getLocalAddress();
                registerIp = localAddress.getHostAddress();
            }
        }
        if (Util.isEmpty((CharSequence)registerIp)) {
            Util.log.error("cannot find right IP , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        if ((port = this.clientNodeConfig.port() > 0 ? this.clientNodeConfig.port() : uri.getPort()) <= 0) {
            Util.log.error("cannot find port , exit JVM.");
            Runtime.getRuntime().exit(-1);
        }
        ClientNode.ClientNodeImpl node = new ClientNode.ClientNodeImpl();
        node.setNode(ClientNode.UUID_STR);
        node.setIp(registerIp);
        node.setPort(port);
        node.setServletPath(this.contextPath);
        node.setApp(this.app);
        return node;
    }
}

