/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.i18hub.sdk.client;

import com.ovopark.i18hub.sdk.client.Link2I18Transport;
import com.ovopark.i18hub.sdk.model.I18PullRequest;
import com.ovopark.i18hub.sdk.model.I18PullResponse;
import com.ovopark.i18hub.sdk.model.I18PushRequest;
import com.ovopark.i18hub.sdk.model.I18PushResponse;
import com.ovopark.kernel.shared.JSONAccessor;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

class Link2I18RestClient
implements Link2I18Transport {
    private static final Logger log = LoggerFactory.getLogger(Link2I18RestClient.class);
    private final RestTemplate restTemplate;

    Link2I18RestClient() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(45000);
        factory.setConnectTimeout(15000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        this.restTemplate.getMessageConverters().add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    @Override
    public I18PullResponse request(I18PullRequest i18PullRequest) {
        return this.rpc(i18PullRequest, "/get", I18PullResponse.class);
    }

    @Override
    public I18PushResponse request(I18PushRequest i18PushRequest) {
        return null;
    }

    private <T> T rpc(Object request, String path, Class<T> clazz) {
        String url = "http://127.0.0.1:13999/cloud-i18hub";
        url = url + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        HttpEntity formEntity = new HttpEntity((Object)JSONAccessor.impl().format(request), (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)formEntity, String.class, new Object[0]);
            int statusCodeValue = responseEntity.getStatusCodeValue();
            if (statusCodeValue == 200) {
                return (T)JSONAccessor.impl().read((String)responseEntity.getBody(), clazz);
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }
}

