/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.proxy;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ovopark.expection.ResultCode;
import com.ovopark.expection.SysErrorException;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.resp.JsonNewResult;
import com.ovopark.organize.common.model.mo.MessageMo;
import com.ovopark.organize.sdk.api.MessageApi;
import com.ovopark.po.DeleteMessagesByObject;
import com.ovopark.po.TaskMessage;
import com.ovopark.utils.DateUtil;
import com.ovopark.utils.DateUtils;
import com.ovopark.utils.HttpUtils;
import com.ovopark.utils.OkHttp3Util;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MessageProxy {
    private static Logger logger = LoggerFactory.getLogger(MessageProxy.class);
    @Value(value="${websocket.url}")
    private String webSocketServerUrl;
    @Value(value="${jpush.url}")
    private String jpushServerUrl;
    public static final ExecutorService executor = Executors.newFixedThreadPool(5);
    @Autowired
    private MessageApi messageApi;

    public void sendWebSocketAndJpush(final Integer targetUserId, final Integer userId, final String title, final String message, final Integer groupId, final Integer type, final Integer relatedId, final InspectionPlanMainTypeEnum mainType, final Integer tokenType, final Integer jumpType, final Integer isExecutor, final Integer isTodoMessage, final Date endTime) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                MessageProxy.this.JpushAndWebSocket(targetUserId, title, message, type, relatedId, mainType.getDesc(), tokenType, jumpType);
                MessageProxy.this.sendWebSocket(message, userId, targetUserId, groupId, 1000, type, relatedId, mainType.getDesc(), jumpType, isExecutor, isTodoMessage, endTime);
            }
        });
    }

    private void JpushAndWebSocket(Integer userId, String title, String message, Integer type, Integer relatedId, String objectType, Integer tokenType, Integer jumpType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", title);
        map.put("userIdList", Arrays.asList(userId));
        map.put("messageType", type);
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("taskId", relatedId);
        jsonMap.put("objectType", objectType);
        jsonMap.put("jumpType", jumpType);
        map.put("taskJson", jsonMap);
        map.put("reason", message);
        logger.info("\u6781\u5149\u63a8\u9001\u8bf7\u6c42\u53c2\u6570\u6570\u636e:" + JSON.toJSONString(map) + "tokenType" + tokenType);
        Callback callback = new Callback(){

            public void onFailure(Call call, IOException e) {
                logger.info("\u6781\u5149\u63a8\u9001 onFailure: " + e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                ResponseBody body = response.body();
                if (body != null) {
                    logger.info("\u6781\u5149\u63a8\u9001Success \u8fd4\u56de\u7ed3\u679c:" + response.body().string());
                    body.close();
                }
            }
        };
        OkHttp3Util.doPostCallBack((String)this.jpushServerUrl, map, (Callback)callback);
    }

    private void sendWebSocket(String content, Integer userId, Integer targetUserId, Integer enterpriseId, Integer messageType, Integer type, Integer relatedId, String objectType, Integer jumpType, Integer isExecutor, Integer isTodoMessage, Date endTime) {
        Date now = new Date();
        String nowStr = DateUtil.format((Date)now);
        String category = "TYPE_STORE_PLAN_SYSTEM";
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap detailMap = new HashMap();
        param.put("type", type);
        if (relatedId != null) {
            param.put("taskId", relatedId);
        }
        MessageMo msg = new MessageMo();
        msg.setContent(content);
        msg.setCreateTime(DateUtils.format((Date)now, (String)DateUtils.FORMAT_LONG));
        msg.setEnterpriseId(enterpriseId);
        msg.setSrcUserId(userId);
        msg.setTargetUserId(targetUserId);
        msg.setObjectId(jumpType);
        msg.setSubId(relatedId);
        msg.setObjectType(objectType);
        msg.setCategory(category);
        msg.setDescription(JSONObject.toJSONString(param));
        msg.setOptionState(Integer.valueOf(0));
        msg.setIsTodoMessage(isTodoMessage != null ? isTodoMessage : IsTodoMessageEnum.MESSAGE.getCode());
        if (msg.getIsTodoMessage().equals(IsTodoMessageEnum.IS_TODO_MESSAGE.getCode())) {
            msg.setEndTime(endTime);
            msg.setIsExecutor(isExecutor != null ? isExecutor : IsExecutorEnum.EXECUTOR.getCode());
        }
        param.put("newObjectType", "INSPECTION_PLAN");
        msg.setDetails(JSONObject.toJSONString(param));
        long id = (Long)this.messageApi.saveMessages(msg).getData();
        logger.info("\u6d88\u606f\u63a8\u9001\u8fd4\u56demessageId:" + id);
        TaskMessage message = new TaskMessage();
        message.setContent(content);
        message.setCreateTime(nowStr);
        message.setEnterpriseId(enterpriseId);
        message.setSrcUserId(userId);
        message.setTargetUserId(targetUserId);
        message.setSubId(relatedId);
        message.setObjectType(objectType);
        message.setDescription(JSONObject.toJSONString(param));
        message.setId(id);
        message.setStatus(Integer.valueOf(0));
        message.setCategory(category);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", targetUserId + "");
        map.put("clients", "Android,iOS");
        map.put("message", JSONObject.toJSONString((Object)message));
        map.put("messageType", String.valueOf(messageType));
        logger.info("webSocket\u8bf7\u6c42\u53c2\u6570" + JSON.toJSONString(map));
        String result = HttpUtils.sendJsonToOtherServerDefault((String)this.webSocketServerUrl, map);
        logger.info("webSocket\u8fd4\u56de\u7ed3\u679c" + result);
        JsonNewResult jsonNewResult = (JsonNewResult)JSON.parseObject((String)result, JsonNewResult.class);
        if (jsonNewResult == null || jsonNewResult.getIsError().booleanValue()) {
            throw new SysErrorException(ResultCode.WEBSOECK_ERROR, new Object[0]);
        }
    }

    public void deleteMessagesByObject(DeleteMessagesByObject msg) {
        this.messageApi.deleteMessagesByObject(msg.getObjectType(), msg.getObjectId(), msg.getTargetUserId(), msg.getSubId(), msg.getIsTodoMessage());
    }
}

