/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.service.Impl;

import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.constants.LogConstant;
import com.ovopark.constants.MessageConstant;
import com.ovopark.mapper.InspectionTaskExpandMapper;
import com.ovopark.model.dto.ExpandCountDto;
import com.ovopark.model.enums.DefaultEnum;
import com.ovopark.model.enums.ExpandExecuteExpireEnum;
import com.ovopark.model.enums.InspectionPlanMainTypeEnum;
import com.ovopark.model.enums.InspectionTaskExpandStatusEnum;
import com.ovopark.model.enums.InspectionTaskStatusEnum;
import com.ovopark.model.enums.IsExecutorEnum;
import com.ovopark.model.enums.IsTodoMessageEnum;
import com.ovopark.model.enums.JumpTypeEnum;
import com.ovopark.model.enums.MainTypeEnum;
import com.ovopark.model.login.Users;
import com.ovopark.model.req.FixReq;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.pojo.EnterpriseConfigPojo;
import com.ovopark.organize.sdk.api.EnterpriseGroupsApi;
import com.ovopark.po.InspectionTask;
import com.ovopark.po.InspectionTaskExpand;
import com.ovopark.po.IsInspectionDeptTemplate;
import com.ovopark.pojo.DepartmentPojo;
import com.ovopark.proxy.DepartProxy;
import com.ovopark.proxy.MessageProxy;
import com.ovopark.service.InspectionTaskExpandService;
import com.ovopark.service.InspectionTaskService;
import com.ovopark.service.IsInspectionDeptTemplateService;
import com.ovopark.service.UsersRemoteService;
import com.ovopark.utils.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionTaskExpandServiceImpl
extends ServiceImpl<InspectionTaskExpandMapper, InspectionTaskExpand>
implements InspectionTaskExpandService {
    private static final Logger log = LoggerFactory.getLogger(InspectionTaskExpandServiceImpl.class);
    @Autowired
    private InspectionTaskExpandMapper inspectionTaskExpandMapper;
    @Autowired
    MessageProxy messageProxy;
    @Autowired
    private IsInspectionDeptTemplateService deptTemplateService;
    @Autowired
    private InspectionTaskService taskService;
    @Autowired
    private DepartProxy departProxy;
    @Autowired
    private UsersRemoteService usersRemoteService;
    @Autowired
    private EnterpriseGroupsApi enterpriseGroupsApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void returnExpand(Integer expandId, Integer templateId, Integer operatorId, String templateName) {
        List expireExecutes;
        InspectionTaskExpand taskExpand;
        Date now = new Date();
        InspectionTaskExpand expand = (InspectionTaskExpand)this.getById(expandId);
        BaseResult result = this.enterpriseGroupsApi.getEnterpriseConfig(expand.getGroupId());
        DepartmentPojo department = this.departProxy.getDepartment(expand.getDeptId());
        Users users = this.usersRemoteService.getById(operatorId);
        this.taskService.insertLog(users, expand.getTaskId(), LogConstant.RETURN, users.getShowName(), department != null ? department.getName() : "", templateName);
        if (templateId != null) {
            IsInspectionDeptTemplate one = (IsInspectionDeptTemplate)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getTemplateId, (Object)templateId)).eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).one();
            one.setIsRead(DefaultEnum.DEFAULT_FALSE.getCode());
            this.deptTemplateService.update(one);
        }
        if ((taskExpand = (InspectionTaskExpand)this.getById(expandId)).getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
            return;
        }
        InspectionTask task = (InspectionTask)this.taskService.getById(taskExpand.getTaskId());
        Integer executeExpire = ExpandExecuteExpireEnum.DEFAULT.getCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().eq(IsInspectionDeptTemplate::getExpandId, (Object)expandId)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List collect = list.stream().map(IsInspectionDeptTemplate::getUpdateTime).collect(Collectors.toList());
            Date maxDate = (Date)Collections.max(collect);
            executeExpire = maxDate.after(task.getEndTime()) ? ExpandExecuteExpireEnum.YES.getCode() : ExpandExecuteExpireEnum.NOT.getCode();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(InspectionTaskExpand::getStatus, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).set(InspectionTaskExpand::getFinishTime, null)).set(InspectionTaskExpand::getExecuteExpire, (Object)executeExpire)).eq(InspectionTaskExpand::getId, (Object)expandId)).update();
        Integer completeExpandCount = task.getCompleteExpandCount();
        boolean flag = task.getTotalExpandCount().equals(completeExpandCount);
        completeExpandCount = completeExpandCount > 0 ? Integer.valueOf(completeExpandCount - 1) : Integer.valueOf(0);
        BigDecimal percent = BigDecimalUtils.calculatePercent((Integer)completeExpandCount, (Integer)task.getTotalExpandCount(), (Integer)BigDecimalUtils.DEFAULT_SCALE_FOUR, (Integer)4);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.taskService.lambdaUpdate().eq(InspectionTask::getId, (Object)taskExpand.getTaskId())).set(InspectionTask::getCompleteExpandCount, (Object)completeExpandCount)).set(InspectionTask::getCompletePercent, (Object)percent)).set(InspectionTask::getStatus, (Object)(task.getStatus().equals(InspectionTaskStatusEnum.PASS.getCode()) ? InspectionTaskStatusEnum.PASS.getCode() : InspectionTaskStatusEnum.INSPECT.getCode()))).update();
        if (task.getEndTime().before(now) && result.getData() != null && StringUtils.isNotBlank((String)((EnterpriseConfigPojo)result.getData()).getExpireExecute()) && !(expireExecutes = Stream.of(((EnterpriseConfigPojo)result.getData()).getExpireExecute().split(",")).map(Integer::parseInt).collect(Collectors.toList())).contains(MainTypeEnum.INSPECTION.getCode())) {
            return;
        }
        if (flag) {
            this.messageProxy.sendWebSocketAndJpush(task.getOperatorId(), task.getAuditId(), "\u5de1\u68c0\u8ba1\u5212", String.format(MessageConstant.RETURN_MESSAGE, task.getName()), task.getGroupId(), MessageConstant.INSPECTION_JPUSH_TYPE, task.getId(), InspectionPlanMainTypeEnum.INSPECTION, DefaultEnum.DEFAULT_TRUE.getCode(), JumpTypeEnum.DETAIL.getCode(), IsExecutorEnum.EXECUTOR.getCode(), IsTodoMessageEnum.IS_TODO_MESSAGE.getCode(), task.getEndTime());
        }
    }

    @Override
    public void fix(FixReq req) {
        List tasks = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.taskService.lambdaQuery().eq(InspectionTask::getGroupId, (Object)req.getGroupId())).between(InspectionTask::getEndTime, (Object)req.getStartTime(), (Object)req.getEndTime())).eq(InspectionTask::getIsDeleted, (Object)DefaultEnum.DEFAULT_FALSE.getCode())).list();
        Map<Object, Object> taskMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            taskMap = tasks.stream().collect(Collectors.toMap(InspectionTask::getId, InspectionTask::getEndTime));
            List expands = ((LambdaQueryChainWrapper)this.lambdaQuery().in(InspectionTaskExpand::getTaskId, taskMap.keySet())).list();
            if (CollectionUtils.isNotEmpty((Collection)expands)) {
                Map<Object, Object> expandTemplateMap = new HashMap();
                List expandIds = expands.stream().map(InspectionTaskExpand::getId).collect(Collectors.toList());
                List deptTemplates = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.deptTemplateService.lambdaQuery().in(IsInspectionDeptTemplate::getExpandId, expandIds)).eq(IsInspectionDeptTemplate::getIsRead, (Object)DefaultEnum.DEFAULT_TRUE.getCode())).list();
                if (CollectionUtils.isNotEmpty((Collection)deptTemplates)) {
                    expandTemplateMap = deptTemplates.stream().collect(Collectors.groupingBy(IsInspectionDeptTemplate::getExpandId, Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> c1.getUpdateTime().after(c2.getUpdateTime()) ? c1 : c2), Optional::get)));
                }
                HashMap finalExpandTemplateMap = expandTemplateMap;
                Map<Object, Object> finalTaskMap = taskMap;
                ((Stream)expands.stream().parallel()).forEach(i -> {
                    IsInspectionDeptTemplate deptTemplate = (IsInspectionDeptTemplate)finalExpandTemplateMap.get(i.getId());
                    if (deptTemplate != null && deptTemplate.getUpdateTime().after((Date)finalTaskMap.get(i.getTaskId()))) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.YES.getCode());
                    }
                    if (deptTemplate != null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(deptTemplate.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.PASS.getCode())) {
                        i.setFinishTime(i.getUpdateTime());
                    }
                    if (deptTemplate == null && i.getStatus().equals(InspectionTaskExpandStatusEnum.WAIT.getCode())) {
                        i.setExecuteExpire(ExpandExecuteExpireEnum.DEFAULT.getCode());
                    }
                });
                expands.forEach(System.out::println);
                this.saveOrUpdateBatch(expands);
            }
        }
    }

    @Override
    public List<ExpandCountDto> countFinish(List<Integer> taskIds) {
        return this.inspectionTaskExpandMapper.countFinish(taskIds);
    }
}

